/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.oro.text.perl.Perl5Util;
import org.codehaus.plexus.formica.validation.AbstractValidator;
import org.codehaus.plexus.formica.validation.util.Flags;
import org.codehaus.plexus.util.StringUtils;

public class UrlValidator
extends AbstractValidator {
    public static final int ALLOW_ALL_SCHEMES = 1;
    public static final int ALLOW_2_SLASHES = 2;
    public static final int NO_FRAGMENTS = 4;
    private static final String ALPHA_CHARS = "a-zA-Z";
    private static final String ALPHA_NUMERIC_CHARS = "a-zA-Z\\d";
    private static final String SPECIAL_CHARS = ";/@&=,.?:+$";
    private static final String VALID_CHARS = "[^\\s;/@&=,.?:+$]";
    private static final String SCHEME_CHARS = "a-zA-Z";
    private static final String AUTHORITY_CHARS = "a-zA-Z\\d\\-\\.";
    private static final String ATOM = "[^\\s;/@&=,.?:+$]+";
    private static final String URL_PATTERN = "/^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?/";
    private static final int PARSE_URL_SCHEME = 2;
    private static final int PARSE_URL_AUTHORITY = 4;
    private static final int PARSE_URL_PATH = 5;
    private static final int PARSE_URL_QUERY = 7;
    private static final int PARSE_URL_FRAGMENT = 9;
    private static final String SCHEME_PATTERN = "/^[a-zA-Z]/";
    private static final String AUTHORITY_PATTERN = "/^([a-zA-Z\\d\\-\\.]*)(:\\d*)?(.*)?/";
    private static final int PARSE_AUTHORITY_HOST_IP = 1;
    private static final int PARSE_AUTHORITY_PORT = 2;
    private static final int PARSE_AUTHORITY_EXTRA = 3;
    private static final String PATH_PATTERN = "/^(/[-\\w:@&?=+,.!/~*'%$]*)$/";
    private static final String QUERY_PATTERN = "/^(.*)$/";
    private static final String LEGAL_ASCII_PATTERN = "/^[\\000-\\177]+$/";
    private static final String IP_V4_DOMAIN_PATTERN = "/^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$/";
    private static final String DOMAIN_PATTERN = "/^[^\\s;/@&=,.?:+$]+(\\.[^\\s;/@&=,.?:+$]+)*$/";
    private static final String PORT_PATTERN = "/^:(\\d{1,5})$/";
    private static final String ATOM_PATTERN = "/([^\\s;/@&=,.?:+$]+)/";
    private static final String ALPHA_PATTERN = "/^[a-zA-Z]/";
    private Flags options = null;
    private Set allowedSchemes = new HashSet();
    protected String[] defaultSchemes = new String[]{"http", "https", "ftp"};

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] schemes) {
        this(schemes, 0);
    }

    public UrlValidator(int options) {
        this(null, options);
    }

    public UrlValidator(String[] schemes, int options) {
        this.options = new Flags(options);
        if (this.options.isOn(1L)) {
            return;
        }
        if (schemes == null && this.allowedSchemes.isEmpty()) {
            schemes = this.defaultSchemes;
        }
        this.allowedSchemes.addAll(Arrays.asList(schemes));
    }

    public boolean validate(String value) {
        return this.isValid(value);
    }

    public boolean isValid(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        Perl5Util matchUrlPat = new Perl5Util();
        Perl5Util matchAsciiPat = new Perl5Util();
        if (!matchAsciiPat.match(LEGAL_ASCII_PATTERN, value)) {
            return false;
        }
        if (!matchUrlPat.match(URL_PATTERN, value)) {
            return false;
        }
        String scheme = matchUrlPat.group(2);
        if (!this.isValidScheme(scheme)) {
            return false;
        }
        if (!"file".equals(scheme)) {
            String authority = matchUrlPat.group(4);
            if (authority.indexOf("@") != -1) {
                String userPassword = authority.substring(0, authority.indexOf("@"));
                authority = authority.substring(authority.indexOf("@") + 1);
                if (userPassword.indexOf(":") == -1 || userPassword.indexOf(":") == 0 || userPassword.indexOf(":") == userPassword.length() - 1) {
                    return false;
                }
            }
            if (!this.isValidAuthority(authority)) {
                return false;
            }
        }
        if (!this.isValidPath(matchUrlPat.group(5))) {
            return false;
        }
        if (!this.isValidQuery(matchUrlPat.group(7))) {
            return false;
        }
        return this.isValidFragment(matchUrlPat.group(9));
    }

    protected boolean isValidScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        Perl5Util schemeMatcher = new Perl5Util();
        if (!schemeMatcher.match("/^[a-zA-Z]/", scheme)) {
            return false;
        }
        return !this.options.isOff(1L) || this.allowedSchemes.contains(scheme);
    }

    protected boolean isValidAuthority(String authority) {
        Perl5Util portMatcher;
        if (authority == null) {
            return false;
        }
        Perl5Util authorityMatcher = new Perl5Util();
        Perl5Util matchIPV4Pat = new Perl5Util();
        if (!authorityMatcher.match(AUTHORITY_PATTERN, authority)) {
            return false;
        }
        boolean ipV4Address = false;
        boolean hostname = false;
        String hostIP = authorityMatcher.group(1);
        ipV4Address = matchIPV4Pat.match(IP_V4_DOMAIN_PATTERN, hostIP);
        if (ipV4Address) {
            for (int i = 1; i <= 4; ++i) {
                String ipSegment = matchIPV4Pat.group(i);
                if (ipSegment == null || ipSegment.length() <= 0) {
                    return false;
                }
                try {
                    if (Integer.parseInt(ipSegment) <= 255) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        } else {
            Perl5Util domainMatcher = new Perl5Util();
            hostname = domainMatcher.match(DOMAIN_PATTERN, hostIP);
        }
        if (hostname) {
            String[] domainSegment = new String[10];
            boolean match = true;
            int segmentCount = 0;
            int segmentLength = 0;
            Perl5Util atomMatcher = new Perl5Util();
            while (match) {
                match = atomMatcher.match(ATOM_PATTERN, hostIP);
                if (!match) continue;
                domainSegment[segmentCount] = atomMatcher.group(1);
                segmentLength = domainSegment[segmentCount].length() + 1;
                hostIP = segmentLength >= hostIP.length() ? "" : hostIP.substring(segmentLength);
                ++segmentCount;
            }
            String topLevel = domainSegment[segmentCount - 1];
            if (segmentCount != 1 && (topLevel.length() < 2 || topLevel.length() > 4)) {
                return false;
            }
            Perl5Util alphaMatcher = new Perl5Util();
            if (!alphaMatcher.match("/^[a-zA-Z]/", topLevel.substring(0, 1))) {
                return false;
            }
        }
        if (!hostname && !ipV4Address) {
            return false;
        }
        String port = authorityMatcher.group(2);
        if (port != null && !(portMatcher = new Perl5Util()).match(PORT_PATTERN, port)) {
            return false;
        }
        String extra = authorityMatcher.group(3);
        return UrlValidator.isBlankOrNull(extra);
    }

    protected boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        Perl5Util pathMatcher = new Perl5Util();
        if (!pathMatcher.match(PATH_PATTERN, path)) {
            return false;
        }
        if (path.endsWith("/")) {
            return false;
        }
        int slash2Count = this.countToken("//", path);
        if (this.options.isOff(2L) && slash2Count > 0) {
            return false;
        }
        int slashCount = this.countToken("/", path);
        int dot2Count = this.countToken("..", path);
        return dot2Count <= 0 || slashCount - slash2Count - 1 > dot2Count;
    }

    protected boolean isValidQuery(String query) {
        if (query == null) {
            return true;
        }
        Perl5Util queryMatcher = new Perl5Util();
        return queryMatcher.match(QUERY_PATTERN, query);
    }

    protected boolean isValidFragment(String fragment) {
        if (fragment == null) {
            return true;
        }
        return this.options.isOff(4L);
    }

    protected int countToken(String token, String target) {
        int tokenIndex = 0;
        int count = 0;
        while (tokenIndex != -1) {
            if ((tokenIndex = target.indexOf(token, tokenIndex)) <= -1) continue;
            ++tokenIndex;
            ++count;
        }
        return count;
    }

    private static boolean isBlankOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }
}

