/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.Locale;
import ro.pippo.core.Application;
import ro.pippo.core.Languages;
import ro.pippo.core.Messages;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.TemplateEngine;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.Router;

public abstract class AbstractTemplateEngine
implements TemplateEngine {
    private Languages languages;
    private Messages messages;
    private Router router;
    private PippoSettings pippoSettings;
    private String fileExtension;
    private String templatePathPrefix;

    @Override
    public void init(Application application) {
        this.languages = application.getLanguages();
        this.messages = application.getMessages();
        this.router = application.getRouter();
        this.pippoSettings = application.getPippoSettings();
        this.fileExtension = this.pippoSettings.getString("template.extension", this.getDefaultFileExtension());
        this.templatePathPrefix = this.pippoSettings.getString("template.pathPrefix", "/templates");
    }

    protected abstract String getDefaultFileExtension();

    @Override
    public final void setFileExtension(String extension) {
        this.fileExtension = extension;
    }

    protected final String getFileExtension() {
        return this.fileExtension;
    }

    protected final Languages getLanguages() {
        return this.languages;
    }

    protected final Messages getMessages() {
        return this.messages;
    }

    protected final PippoSettings getPippoSettings() {
        return this.pippoSettings;
    }

    protected final Locale getLocaleOrDefault(String language) {
        return this.languages.getLocaleOrDefault(language);
    }

    protected final Locale getLocaleOrDefault(RouteContext routeContext) {
        return this.languages.getLocaleOrDefault(routeContext);
    }

    protected final String getLanguageOrDefault(String language) {
        return this.languages.getLanguageOrDefault(language);
    }

    protected final String getLanguageOrDefault(RouteContext routeContext) {
        return this.languages.getLanguageOrDefault(routeContext);
    }

    protected final Router getRouter() {
        return this.router;
    }

    protected final String getTemplatePathPrefix() {
        return this.templatePathPrefix;
    }
}

