/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.MultipartConfigElement;
import ro.pippo.core.Application;
import ro.pippo.core.PippoFilter;
import ro.pippo.core.WebServer;
import ro.pippo.core.WebServerSettings;

public abstract class AbstractWebServer<T extends WebServerSettings>
implements WebServer<T> {
    private PippoFilter pippoFilter;
    protected String pippoFilterPath;
    private Application application;
    private T settings;
    protected List<Class<? extends EventListener>> listeners = new CopyOnWriteArrayList<Class<? extends EventListener>>();

    protected abstract T createDefaultSettings();

    @Override
    public T getSettings() {
        if (this.settings == null) {
            this.settings = this.createDefaultSettings();
        }
        return this.settings;
    }

    @Override
    public PippoFilter getPippoFilter() {
        if (this.pippoFilter == null) {
            this.setPippoFilter(this.createPippoFilter());
        }
        return this.pippoFilter;
    }

    @Override
    public WebServer<T> setPippoFilter(PippoFilter pippoFilter) {
        this.pippoFilter = pippoFilter;
        pippoFilter.setApplication(this.application);
        return this;
    }

    @Override
    public String getPippoFilterPath() {
        return this.pippoFilterPath;
    }

    @Override
    public WebServer<T> setPippoFilterPath(String pippoFilterPath) {
        PippoFilter.validateFilterUrlPattern(pippoFilterPath);
        this.pippoFilterPath = pippoFilterPath;
        return this;
    }

    @Override
    public WebServer<T> init(Application application) {
        this.application = application;
        return this;
    }

    @Override
    public WebServer<T> addListener(Class<? extends EventListener> listener) {
        this.listeners.add(listener);
        return this;
    }

    public Application getApplication() {
        return this.application;
    }

    protected PippoFilter createPippoFilter() {
        return new PippoFilter();
    }

    protected MultipartConfigElement createMultipartConfigElement() {
        Application application = this.getApplication();
        String location = application.getUploadLocation();
        long maxFileSize = application.getMaximumUploadSize();
        return new MultipartConfigElement(location, maxFileSize, -1L, 0);
    }
}

