/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.util.StringUtils;

public class ContentTypeEngines {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeEngines.class);
    private final Map<String, ContentTypeEngine> engines = new TreeMap<String, ContentTypeEngine>();
    private final Map<String, ContentTypeEngine> suffixes = new TreeMap<String, ContentTypeEngine>();

    public boolean hasContentTypeEngine(String contentTypeOrSuffix) {
        String[] types;
        String sanitizedTypes = this.sanitizeContentTypes(contentTypeOrSuffix);
        for (String type : types = sanitizedTypes.split(",")) {
            if (!this.engines.containsKey(type)) continue;
            return true;
        }
        return this.suffixes.containsKey(contentTypeOrSuffix.toLowerCase());
    }

    public List<String> getContentTypes() {
        return Collections.unmodifiableList(new ArrayList<String>(this.engines.keySet()));
    }

    public List<String> getContentTypeSuffixes() {
        return Collections.unmodifiableList(new ArrayList<String>(this.suffixes.keySet()));
    }

    public ContentTypeEngine registerContentTypeEngine(Class<? extends ContentTypeEngine> engineClass) {
        ContentTypeEngine engine;
        try {
            engine = engineClass.newInstance();
        }
        catch (Exception e) {
            throw new PippoRuntimeException(e, "Failed to instantiate '{}'", engineClass.getName());
        }
        if (!this.engines.containsKey(engine.getContentType())) {
            this.setContentTypeEngine(engine);
            return engine;
        }
        log.debug("'{}' content engine already registered, ignoring '{}'", (Object)engine.getContentType(), (Object)engineClass.getName());
        return null;
    }

    public ContentTypeEngine getContentTypeEngine(String contentTypeOrSuffix) {
        String[] types;
        if (StringUtils.isNullOrEmpty(contentTypeOrSuffix)) {
            return null;
        }
        String sanitizedTypes = this.sanitizeContentTypes(contentTypeOrSuffix);
        for (String type : types = sanitizedTypes.split(",")) {
            ContentTypeEngine engine = this.engines.get(type);
            if (engine == null) continue;
            return engine;
        }
        return this.suffixes.get(contentTypeOrSuffix.toLowerCase());
    }

    public void setContentTypeEngine(ContentTypeEngine engine) {
        String contentType = engine.getContentType();
        String suffix = StringUtils.removeStart(contentType.substring(contentType.lastIndexOf(47) + 1), "x-");
        this.engines.put(engine.getContentType(), engine);
        this.suffixes.put(suffix.toLowerCase(), engine);
        log.debug("'{}' content engine is '{}'", (Object)engine.getContentType(), (Object)engine.getClass().getName());
    }

    protected String sanitizeContentTypes(String contentType) {
        String[] types;
        if (StringUtils.isNullOrEmpty(contentType)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String type : types = contentType.split(",")) {
            if (type.contains(";")) {
                type = type.substring(0, type.indexOf(59));
            }
            sb.append(type).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

