/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.Error;
import ro.pippo.core.ErrorHandler;
import ro.pippo.core.ExceptionHandler;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.StatusCodeException;
import ro.pippo.core.StatusCodeExceptionHandler;
import ro.pippo.core.TemplateEngine;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.StringUtils;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorHandler.class);
    private static final String MESSAGE = "message";
    private static final String STACKTRACE = "stacktrace";
    private Application application;
    private final Map<Class<? extends Exception>, ExceptionHandler> exceptionHandlers;

    public DefaultErrorHandler(Application application) {
        this.application = application;
        this.exceptionHandlers = new HashMap<Class<? extends Exception>, ExceptionHandler>();
        this.setExceptionHandler(StatusCodeException.class, new StatusCodeExceptionHandler(this));
    }

    @Override
    public void setExceptionHandler(Class<? extends Exception> exceptionClass, ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.put(exceptionClass, exceptionHandler);
    }

    @Override
    public ExceptionHandler getExceptionHandler(Exception exception) {
        Class<?> exceptionClass = exception.getClass();
        if (!this.exceptionHandlers.containsKey(exceptionClass)) {
            for (Class<?> superClass = exceptionClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                if (!this.exceptionHandlers.containsKey(superClass)) continue;
                ExceptionHandler exceptionHandler = this.exceptionHandlers.get(superClass);
                this.exceptionHandlers.put(exceptionClass, exceptionHandler);
                return exceptionHandler;
            }
            this.exceptionHandlers.put(exceptionClass, null);
        }
        return this.exceptionHandlers.get(exceptionClass);
    }

    @Override
    public void handle(int statusCode, RouteContext routeContext) {
        this.checkForRecursion(routeContext);
        routeContext.status(statusCode);
        String contentType = routeContext.getResponse().getContentType();
        if (StringUtils.isNullOrEmpty(contentType)) {
            String acceptType;
            if (!StringUtils.isNullOrEmpty(routeContext.getRequest().getAcceptType()) && ((acceptType = routeContext.getRequest().getAcceptType()).startsWith("text/html") || acceptType.startsWith("text/xhtml"))) {
                contentType = "text/html";
            }
            if (StringUtils.isNullOrEmpty(contentType)) {
                routeContext.negotiateContentType();
                contentType = routeContext.getResponse().getContentType();
            }
        }
        if (StringUtils.isNullOrEmpty(contentType)) {
            log.debug("No accept type nor content type specified! Defaulting to text/html.");
            this.renderHtml(statusCode, routeContext);
        } else if (contentType.equals("text/html")) {
            this.renderHtml(statusCode, routeContext);
        } else {
            ContentTypeEngine engine = this.application.getContentTypeEngine(contentType);
            if (engine == null) {
                log.warn("No registered content type engine for '{}'", (Object)contentType);
                this.renderHtml(statusCode, routeContext);
            } else {
                Error error = this.prepareError(statusCode, routeContext);
                try {
                    routeContext.getResponse().contentType(contentType).send(error);
                }
                catch (Exception e) {
                    log.error("Unexpected error generating '{}' as '{}'", new Object[]{Error.class.getName(), contentType, e});
                    routeContext.status(500);
                    routeContext.send(this.application.getMessages().get("pippo.statusCode500", routeContext, new Object[0]));
                }
            }
        }
    }

    protected void renderHtml(int statusCode, RouteContext routeContext) {
        TemplateEngine engine = this.application.getTemplateEngine();
        if (engine == null) {
            this.renderDirectly(statusCode, routeContext);
        } else {
            String template = this.getTemplateForStatusCode(statusCode);
            if (template == null) {
                log.debug("There is no {} template for status code '{}'", (Object)engine.getClass().getSimpleName(), (Object)statusCode);
                this.renderDirectly(statusCode, routeContext);
            } else {
                try {
                    Error error = this.prepareError(statusCode, routeContext);
                    Map<String, Object> bindings = error.asMap();
                    bindings.putAll(this.prepareTemplateBindings(statusCode, routeContext));
                    routeContext.setLocals(bindings);
                    routeContext.render(template);
                }
                catch (Exception e) {
                    log.error("Unexpected error rendering '{}' template", (Object)template, (Object)e);
                    this.renderDirectly(statusCode, routeContext);
                }
            }
        }
    }

    @Override
    public void handle(Exception exception, RouteContext routeContext) {
        this.checkForRecursion(routeContext);
        if (exception instanceof PippoRuntimeException && exception.getCause() instanceof Exception) {
            this.handle((Exception)exception.getCause(), routeContext);
        } else {
            ExceptionHandler exceptionHandler = this.getExceptionHandler(exception);
            if (exceptionHandler != null) {
                log.debug("Handling '{}' with '{}'", (Object)exception.getClass().getSimpleName(), (Object)exceptionHandler.getClass().getName());
                exceptionHandler.handle(exception, routeContext);
                return;
            }
            log.error(exception.getMessage(), (Throwable)exception);
            if (routeContext.getResponse().isCommitted()) {
                log.debug("The response has already been committed. Cannot use the exception handler.");
                return;
            }
            String message = exception.getMessage();
            if (!StringUtils.isNullOrEmpty(message) && !routeContext.getResponse().getLocals().containsKey(MESSAGE)) {
                routeContext.setLocal(MESSAGE, message);
            }
            if (this.application.getPippoSettings().isDev()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String stackTrace = stringWriter.toString();
                routeContext.setLocal(STACKTRACE, stackTrace);
            }
            this.handle(500, routeContext);
        }
    }

    protected void renderDirectly(int statusCode, RouteContext routeContext) {
        if (this.application.getPippoSettings().isProd()) {
            routeContext.getResponse().commit();
        } else if (statusCode == 404) {
            StringBuilder content = new StringBuilder();
            content.append("<html><body>");
            content.append("<pre>");
            content.append("Cannot find a route for '");
            content.append(routeContext.getRequestMethod()).append(' ').append(routeContext.getRequestUri());
            content.append('\'');
            content.append('\n');
            content.append("Available routes:");
            content.append('\n');
            List<Route> routes = this.application.getRouter().getRoutes();
            for (Route route : routes) {
                content.append('\t').append(route.getRequestMethod()).append(' ').append(route.getUriPattern());
                content.append('\n');
            }
            content.append("</pre>");
            content.append("</body></html>");
            routeContext.send(content);
        } else if (statusCode == 500) {
            StringBuilder content = new StringBuilder();
            content.append("<html><body>");
            content.append("<pre>");
            Error error = this.prepareError(statusCode, routeContext);
            content.append(error.toString());
            content.append("</pre>");
            content.append("</body></html>");
            routeContext.send(content);
        }
    }

    protected Map<String, Object> prepareTemplateBindings(int statusCode, RouteContext routeContext) {
        LinkedHashMap<String, Object> locals = new LinkedHashMap<String, Object>();
        locals.put("applicationName", this.application.getApplicationName());
        locals.put("applicationVersion", this.application.getApplicationVersion());
        locals.put("runtimeMode", this.application.getPippoSettings().getRuntimeMode().toString());
        if (this.application.getPippoSettings().isDev()) {
            locals.put("routes", this.application.getRouter().getRoutes());
        }
        return locals;
    }

    protected Error prepareError(int statusCode, RouteContext routeContext) {
        String messageKey = "pippo.statusCode" + statusCode;
        Error error = new Error();
        error.setStatusCode(statusCode);
        error.setStatusMessage(this.application.getMessages().get(messageKey, routeContext, new Object[0]));
        error.setRequestMethod(routeContext.getRequestMethod());
        error.setRequestUri(routeContext.getRequestUri());
        error.setStacktrace((String)routeContext.getLocal(STACKTRACE));
        error.setMessage((String)routeContext.getLocal(MESSAGE));
        return error;
    }

    protected String getTemplateForStatusCode(int statusCode) {
        switch (statusCode) {
            case 400: {
                return "pippo/400badRequest";
            }
            case 401: {
                return "pippo/401unauthorized";
            }
            case 402: {
                return "pippo/402paymentRequired";
            }
            case 403: {
                return "pippo/403forbidden";
            }
            case 404: {
                return "pippo/404notFound";
            }
            case 405: {
                return "pippo/405methodNotAllowed";
            }
            case 409: {
                return "pippo/409conflict";
            }
            case 410: {
                return "pippo/410gone";
            }
            default: {
                return "pippo/500internalError";
            }
            case 501: {
                return "pippo/501notImplemented";
            }
            case 502: {
                return "pippo/502overloaded";
            }
            case 503: 
        }
        return "pippo/503serviceUnavailable";
    }

    private void checkForRecursion(RouteContext routeContext) {
        Integer depth = (Integer)routeContext.removeLocal("__errorHandlerDepth");
        if (depth == null) {
            depth = 0;
        }
        depth = depth + 1;
        routeContext.setLocal("__errorHandlerDepth", depth);
        if (depth > 4) {
            throw new PippoRuntimeException("Recursion in error handler", new Object[0]);
        }
    }
}

