/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.StringUtils;

public class Languages {
    private static final Logger log = LoggerFactory.getLogger(Languages.class);
    private final String applicationCookiePrefix;
    private static final int TEN_YEARS = 315360000;
    private final PippoSettings pippoSettings;
    private final String defaultLanguage;
    private final Map<String, String> languageLookup;

    public Languages(PippoSettings pippoSettings) {
        this.pippoSettings = pippoSettings;
        this.applicationCookiePrefix = pippoSettings.getString("application.cookie.prefix", "PIPPO");
        this.languageLookup = new ConcurrentHashMap<String, String>();
        List<String> languages = pippoSettings.getStrings("application.languages");
        for (String language : languages) {
            String lang = language.toLowerCase();
            String langComponent = this.getLanguageComponent(lang);
            this.languageLookup.put(lang, language);
            this.languageLookup.put(langComponent, language);
        }
        this.defaultLanguage = this.getDefaultLanguage(languages);
        log.info("Using '{}' as default language.", (Object)this.defaultLanguage);
    }

    public String getLanguageComponent(String language) {
        if (StringUtils.isNullOrEmpty(language)) {
            return "";
        }
        if (language.contains("-")) {
            return language.split("-")[0];
        }
        if (language.contains("_")) {
            return language.split("_")[0];
        }
        return language;
    }

    public boolean isSupportedLanguage(String language) {
        String lang = this.getLanguageComponent(language);
        return this.languageLookup.containsKey(lang);
    }

    public boolean isRegisteredLanguage(String language) {
        String lang = this.getLanguageOrDefault(language);
        return this.getRegisteredLanguages().contains(lang);
    }

    public List<String> getRegisteredLanguages() {
        return this.pippoSettings.getStrings("application.languages");
    }

    public void clearLanguageCookie(Response response) {
        String cookieName = this.generateLanguageCookie("").getName();
        response.removeCookie(cookieName);
    }

    public void setLanguageCookie(String language, RouteContext routeContext) {
        String lang = this.getLanguageOrDefault(language);
        if (!lang.equals(language)) {
            throw new PippoRuntimeException("'{}' is not a registered language!", language);
        }
        Cookie cookie = this.generateLanguageCookie(language);
        routeContext.getResponse().cookie(cookie);
    }

    public String getLanguageOrDefault(RouteContext routeContext) {
        String cookieName = this.generateLanguageCookie(this.defaultLanguage).getName();
        Cookie cookie = routeContext.getResponse().getCookie(cookieName);
        if (cookie != null && !StringUtils.isNullOrEmpty(cookie.getValue())) {
            return this.getLanguageOrDefault(cookie.getValue());
        }
        cookie = routeContext.getRequest().getCookie(cookieName);
        if (cookie != null && !StringUtils.isNullOrEmpty(cookie.getValue())) {
            return this.getLanguageOrDefault(cookie.getValue());
        }
        if (routeContext.getResponse().getLocals().containsKey("lang")) {
            String language = (String)routeContext.getLocal("lang");
            language = this.getLanguageOrDefault(language);
            return language;
        }
        String acceptLanguage = routeContext.getHeader("Accept-Language");
        return this.getLanguageOrDefault(acceptLanguage);
    }

    public Locale getLocaleOrDefault(RouteContext routeContext) {
        String language = this.getLanguageOrDefault(routeContext);
        return Locale.forLanguageTag(language);
    }

    public Locale getLocaleOrDefault(String language) {
        String lang = this.getLanguageOrDefault(language);
        return Locale.forLanguageTag(lang);
    }

    public String getLanguageOrDefault(String language) {
        if (!StringUtils.isNullOrEmpty(language)) {
            String[] languages;
            for (String lang : languages = language.toLowerCase().split(",")) {
                if (lang.contains(";")) {
                    lang = lang.split(";")[0];
                }
                if (!this.isSupportedLanguage(lang)) continue;
                return lang;
            }
        }
        return this.defaultLanguage;
    }

    private Cookie generateLanguageCookie(String language) {
        Cookie cookie = new Cookie(this.applicationCookiePrefix + "_LANG", language);
        cookie.setSecure(true);
        cookie.setMaxAge(315360000);
        return cookie;
    }

    private String getDefaultLanguage(List<String> applicationLanguages) {
        if (applicationLanguages.isEmpty()) {
            String NO_LANGUAGES_TEXT = "Please specify the supported languages in 'application.properties'. For example 'application.languages=en, ro, de, pt-BR' makes 'en' your default language.";
            log.error(NO_LANGUAGES_TEXT);
            return "en";
        }
        return applicationLanguages.get(0);
    }
}

