/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Request;
import ro.pippo.core.RequestResponse;
import ro.pippo.core.RequestResponseFactory;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteDispatcher;
import ro.pippo.core.util.PippoUtils;
import ro.pippo.core.util.StringUtils;

public class PippoFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PippoFilter.class);
    public static final String FILTER_MAPPING_PARAM = "filterMappingUrlPattern";
    public static final String APPLICATION_CLASS_PARAM = "applicationClassName";
    public static final String MODE_PARAM = "mode";
    private RouteDispatcher routeDispatcher;
    private Application application;
    private String filterPath;

    public void init(FilterConfig filterConfig) throws ServletException {
        String mode;
        if (System.getProperty("pippo.hideLogo") == null) {
            log.info(PippoUtils.getPippoLogo());
        }
        if (!StringUtils.isNullOrEmpty(mode = filterConfig.getInitParameter(MODE_PARAM))) {
            System.setProperty("pippo.mode", mode);
        }
        if (this.application == null) {
            this.createApplication(filterConfig);
            log.debug("Created application '{}'", (Object)this.application);
        }
        ServletContext servletContext = filterConfig.getServletContext();
        this.application.setServletContext(servletContext);
        if (servletContext.getAttribute("PIPPO_APPLICATION") == null) {
            servletContext.setAttribute("PIPPO_APPLICATION", (Object)this.application);
        }
        try {
            String contextPath = StringUtils.addStart(servletContext.getContextPath(), "/");
            this.application.getRouter().setContextPath(contextPath);
            if (this.filterPath == null) {
                this.initFilterPath(filterConfig);
            }
            String applicationPath = StringUtils.addEnd(contextPath, "/") + StringUtils.removeStart(this.filterPath, "/");
            this.application.getRouter().setApplicationPath(applicationPath);
            if (!contextPath.equals(applicationPath)) {
                log.debug("Context path is '{}'", (Object)contextPath);
            }
            log.debug("Serving application on path '{}'", (Object)applicationPath);
            log.debug("Initializing Route Dispatcher");
            this.routeDispatcher = new RouteDispatcher(this.application);
            this.routeDispatcher.init();
            String runtimeMode = this.application.getRuntimeMode().toString().toUpperCase();
            log.info("Pippo started ({})", (Object)runtimeMode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.destroy();
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        RequestResponseFactory requestResponseFactory = this.application.getRequestResponseFactory();
        RequestResponse requestResponse = requestResponseFactory.createRequestResponse(httpServletRequest, httpServletResponse);
        Request request = requestResponse.getRequest();
        Response response = requestResponse.getResponse();
        URI uri = URI.create(httpServletRequest.getRequestURL().toString());
        String requestUri = uri.getPath();
        String requestPath = request.getPath();
        log.trace("The relative path for '{}' is '{}'", (Object)requestUri, (Object)requestPath);
        if (this.shouldIgnorePath(requestPath)) {
            log.debug("Ignoring request '{}'", (Object)requestPath);
            if (chain != null) {
                chain.doFilter(servletRequest, servletResponse);
            }
            return;
        }
        log.debug("Request {} '{}'", (Object)request.getMethod(), (Object)requestPath);
        this.processRequest(request, response);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void destroy() {
        if (this.application != null) {
            try {
                this.application.destroy();
                log.info("Pippo destroyed");
            }
            finally {
                this.application = null;
            }
        }
    }

    protected void processRequest(Request request, Response response) throws IOException, ServletException {
        this.routeDispatcher.dispatch(request, response);
    }

    protected void setFilterPath(String urlPattern) {
        this.initFilterPath(urlPattern);
    }

    private boolean shouldIgnorePath(String requestUri) {
        for (String path : this.application.getRouter().getIgnorePaths()) {
            if (!requestUri.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private void initFilterPath(FilterConfig filterConfig) {
        this.initFilterPathFromConfig(filterConfig);
        if (this.filterPath == null) {
            this.initFilterPathFromWebXml(filterConfig);
        }
        if (this.filterPath == null) {
            StringBuilder message = new StringBuilder();
            message.append("Unable to determine filter path from filter init-param, web.xml.");
            message.append("Assuming user will set filter path manually by calling setFilterPath(String)");
            log.warn(message.toString());
        }
    }

    private void initFilterPathFromConfig(FilterConfig filterConfig) {
        String filterMapping = filterConfig.getInitParameter(FILTER_MAPPING_PARAM);
        if (filterMapping != null) {
            this.initFilterPath(filterMapping);
        }
    }

    private void initFilterPathFromWebXml(FilterConfig filterConfig) {
        String filterName = filterConfig.getFilterName();
        FilterRegistration filterRegistration = filterConfig.getServletContext().getFilterRegistration(filterName);
        Collection mappings = filterRegistration.getUrlPatternMappings();
        int size = mappings.size();
        if (size > 1) {
            throw new PippoRuntimeException("Expected one filter path for '{}' but found multiple", filterName);
        }
        if (size == 1) {
            String urlPattern = (String)mappings.iterator().next();
            this.initFilterPath(urlPattern);
        }
    }

    private void initFilterPath(String urlPattern) {
        PippoFilter.validateFilterUrlPattern(urlPattern);
        this.filterPath = urlPattern.substring(1, urlPattern.length() - 1);
    }

    protected void createApplication(FilterConfig filterConfig) throws ServletException {
        String applicationClassName = filterConfig.getInitParameter(APPLICATION_CLASS_PARAM);
        if (applicationClassName == null) {
            log.error("Filter init param '{}' is missing", (Object)APPLICATION_CLASS_PARAM);
            throw new ServletException("Cannot found application class name");
        }
        try {
            Class<?> applicationClass = Class.forName(applicationClassName);
            this.application = (Application)applicationClass.newInstance();
        }
        catch (Exception e) {
            log.error("Cannot create application with className '{}'", (Object)applicationClassName, (Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static void validateFilterUrlPattern(String urlPattern) {
        if (!urlPattern.startsWith("/") || !urlPattern.endsWith("/*")) {
            throw new PippoRuntimeException("Your '{}' must start with '{}' and end with '{}'. It's '{}'", FILTER_MAPPING_PARAM, "/", "/*", urlPattern);
        }
    }
}

