/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.RuntimeMode;
import ro.pippo.core.util.ClasspathUtils;
import ro.pippo.core.util.StringUtils;

public class PippoSettings {
    private static final Logger log = LoggerFactory.getLogger(PippoSettings.class);
    private static final String USING_DEFAULT_OF = " using default of ";
    private static final String DEFAULT_LIST_DELIMITER = ",";
    private final RuntimeMode runtimeMode;
    private final Properties properties;
    private final Properties overrides;
    private final Map<String, String> interpolationValues;
    private final URL propertiesUrl;
    private final boolean isFile;
    private volatile long lastModified;

    public PippoSettings(RuntimeMode runtimeMode) {
        this.runtimeMode = runtimeMode;
        this.propertiesUrl = this.getPropertiesUrl();
        this.isFile = this.propertiesUrl.getProtocol().equals("file:");
        this.interpolationValues = new HashMap<String, String>();
        this.loadInterpolationValues();
        this.properties = this.loadProperties(this.propertiesUrl);
        this.overrides = new Properties();
    }

    public RuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    public boolean isDev() {
        return RuntimeMode.DEV == this.runtimeMode;
    }

    public boolean isTest() {
        return RuntimeMode.TEST == this.runtimeMode;
    }

    public boolean isProd() {
        return RuntimeMode.PROD == this.runtimeMode;
    }

    public String getLocalHostname() {
        try {
            String result = InetAddress.getLocalHost().getHostName();
            if (!StringUtils.isNullOrEmpty(result)) {
                return result;
            }
        }
        catch (UnknownHostException result) {
            // empty catch block
        }
        String host = System.getenv("COMPUTERNAME");
        if (host != null) {
            return host;
        }
        host = System.getenv("HOSTNAME");
        if (host != null) {
            return host;
        }
        return "Pippo";
    }

    private URL getPropertiesUrl() {
        URL url = null;
        try {
            String systemProperty = System.getProperty("pippo.settings", null);
            if (!StringUtils.isNullOrEmpty(systemProperty)) {
                url = URI.create(systemProperty).toURL();
                log.debug("Located '{}' using the '{}' system property", (Object)url, (Object)"pippo.settings");
            }
        }
        catch (MalformedURLException e) {
            log.error("Failed to parse '{}' system property!", (Object)"pippo.settings");
        }
        try {
            Path path = Paths.get(System.getProperty("user.dir"), "application.properties");
            if (path.toFile().exists()) {
                url = path.toUri().toURL();
                log.debug("Located '{}' in the current working directory", (Object)url);
            }
        }
        catch (MalformedURLException e) {
            log.error("Failed to parse working directory properties!", (Throwable)e);
        }
        if (url == null) {
            url = ClasspathUtils.locateOnClasspath("conf/application.properties");
        }
        if (url == null) {
            url = ClasspathUtils.locateOnClasspath("pippo/pippo-builtin.properties");
        }
        return url;
    }

    private synchronized Properties getProperties() {
        File file;
        if (this.isFile && (file = new File(this.propertiesUrl.getPath())).lastModified() > this.lastModified) {
            Properties reloadedProperties = this.loadProperties(this.propertiesUrl);
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)reloadedProperties);
            this.lastModified = file.lastModified();
        }
        return this.properties;
    }

    private synchronized Properties loadProperties(URL propertiesUrl) {
        Properties properties = new Properties();
        try (BufferedReader is = new BufferedReader(new InputStreamReader(propertiesUrl.openStream(), StandardCharsets.UTF_8));){
            log.debug("loading {}", (Object)propertiesUrl);
            Properties props = new Properties();
            props.load(is);
            File baseDir = this.isFile ? new File(propertiesUrl.getPath()).getParentFile() : new File(System.getProperty("user.dir"));
            props = this.loadIncludes(baseDir, props);
            props = this.loadOverrides(baseDir, props);
            String prefix = "%" + this.runtimeMode.toString() + ".";
            TreeSet<String> names = new TreeSet<String>(props.stringPropertyNames());
            for (String name : names) {
                if (name.charAt(0) == '%') {
                    if (!name.startsWith(prefix)) continue;
                    properties.put(name.substring(prefix.length()), props.get(name));
                    continue;
                }
                if (properties.containsKey(name)) continue;
                properties.put(name, props.get(name));
            }
        }
        catch (FileNotFoundException f) {
            throw new PippoRuntimeException(f, "Failed to find {}", propertiesUrl);
        }
        catch (Exception t) {
            throw new PippoRuntimeException(t, "Failed to read {}", propertiesUrl);
        }
        return properties;
    }

    private Properties loadIncludes(File baseDir, Properties properties) throws IOException {
        return this.loadProperties(baseDir, properties, "include", false);
    }

    private Properties loadOverrides(File baseDir, Properties properties) throws IOException {
        return this.loadProperties(baseDir, properties, "override", true);
    }

    private Properties loadProperties(File baseDir, Properties currentProperties, String key, boolean override) throws IOException {
        Properties loadedProperties = new Properties();
        String include = (String)currentProperties.remove(key);
        if (!StringUtils.isNullOrEmpty(include)) {
            List<String> names = StringUtils.getList(include, DEFAULT_LIST_DELIMITER);
            for (String name : names) {
                if (StringUtils.isNullOrEmpty(name)) continue;
                String fileName = this.interpolateString(name);
                File file = new File(baseDir, fileName);
                if (!file.exists()) {
                    file = new File(fileName);
                }
                if (!file.exists()) {
                    log.warn("failed to locate {}", (Object)file);
                    continue;
                }
                log.debug("loading {} settings from {}", (Object)key, (Object)file);
                try (FileInputStream iis = new FileInputStream(file);){
                    loadedProperties.load(iis);
                }
                loadedProperties = this.loadProperties(file.getParentFile(), loadedProperties, key, override);
            }
        }
        Properties merged = new Properties();
        if (override) {
            merged.putAll((Map<?, ?>)currentProperties);
            merged.putAll((Map<?, ?>)loadedProperties);
        } else {
            merged.putAll((Map<?, ?>)loadedProperties);
            merged.putAll((Map<?, ?>)currentProperties);
        }
        return merged;
    }

    protected void loadInterpolationValues() {
        String value;
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            value = System.getProperty(propertyName);
            if (StringUtils.isNullOrEmpty(value)) continue;
            this.addInterpolationValue(propertyName, value);
        }
        for (String variableName : System.getenv().keySet()) {
            value = System.getenv(variableName);
            if (StringUtils.isNullOrEmpty(value)) continue;
            this.addInterpolationValue("env." + variableName, value);
        }
    }

    protected void addInterpolationValue(String name, String value) {
        this.interpolationValues.put(String.format("${%s}", name), value);
        this.interpolationValues.put(String.format("@{%s}", name), value);
    }

    protected String interpolateString(String value) {
        String interpolatedValue = value;
        for (Map.Entry<String, String> entry : this.interpolationValues.entrySet()) {
            interpolatedValue = interpolatedValue.replace(entry.getKey(), entry.getValue());
        }
        return interpolatedValue;
    }

    public List<String> getSettingNames() {
        return this.getSettingNames(null);
    }

    public List<String> getSettingNames(String startingWith) {
        ArrayList<String> names = new ArrayList<String>();
        Properties props = this.getProperties();
        if (StringUtils.isNullOrEmpty(startingWith)) {
            names.addAll(props.stringPropertyNames());
        } else {
            startingWith = startingWith.toLowerCase();
            for (Object o : props.keySet()) {
                String name = o.toString();
                if (!name.toLowerCase().startsWith(startingWith)) continue;
                names.add(name);
            }
        }
        return names;
    }

    public String getString(String name, String defaultValue) {
        String value = this.getProperties().getProperty(name, defaultValue);
        value = this.overrides.getProperty(name, value);
        return value;
    }

    public String getInterpolatedString(String name, String defaultValue) {
        String value = this.getString(name, defaultValue);
        return this.interpolateString(value);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getString(name, null);
        if (!StringUtils.isNullOrEmpty(value)) {
            return Boolean.parseBoolean(value.trim());
        }
        return defaultValue;
    }

    public int getInteger(String name, int defaultValue) {
        try {
            String value = this.getString(name, null);
            if (!StringUtils.isNullOrEmpty(value)) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse integer for " + name + USING_DEFAULT_OF + defaultValue);
        }
        return defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        try {
            String value = this.getString(name, null);
            if (!StringUtils.isNullOrEmpty(value)) {
                return Long.parseLong(value.trim());
            }
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse long for " + name + USING_DEFAULT_OF + defaultValue);
        }
        return defaultValue;
    }

    public float getFloat(String name, float defaultValue) {
        try {
            String value = this.getString(name, null);
            if (!StringUtils.isNullOrEmpty(value)) {
                return Float.parseFloat(value.trim());
            }
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse float for " + name + USING_DEFAULT_OF + defaultValue);
        }
        return defaultValue;
    }

    public double getDouble(String name, double defaultValue) {
        try {
            String value = this.getString(name, null);
            if (!StringUtils.isNullOrEmpty(value)) {
                return Double.parseDouble(value.trim());
            }
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse double for " + name + USING_DEFAULT_OF + defaultValue);
        }
        return defaultValue;
    }

    public char getChar(String name, char defaultValue) {
        String value = this.getString(name, null);
        if (!StringUtils.isNullOrEmpty(value)) {
            return value.trim().charAt(0);
        }
        return defaultValue;
    }

    public String getRequiredString(String name) {
        String value = this.getString(name, null);
        if (value != null) {
            return value.trim();
        }
        throw new PippoRuntimeException("Setting '{}' has not been configured!", name);
    }

    public List<String> getStrings(String name) {
        return this.getStrings(name, DEFAULT_LIST_DELIMITER);
    }

    public List<String> getStrings(String name, String delimiter) {
        String value = this.getString(name, null);
        if (StringUtils.isNullOrEmpty(value)) {
            return Collections.emptyList();
        }
        if ((value = value.trim()).startsWith("[") && value.endsWith("]")) {
            value = value.substring(1, value.length() - 1);
        }
        return StringUtils.getList(value, delimiter);
    }

    public List<Integer> getIntegers(String name) {
        return this.getIntegers(name, DEFAULT_LIST_DELIMITER);
    }

    public List<Integer> getIntegers(String name, String delimiter) {
        List<String> strings = this.getStrings(name, delimiter);
        ArrayList<Integer> ints = new ArrayList<Integer>(strings.size());
        for (String value : strings) {
            try {
                int i = Integer.parseInt(value);
                ints.add(i);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Collections.unmodifiableList(ints);
    }

    public List<Long> getLongs(String name) {
        return this.getLongs(name, DEFAULT_LIST_DELIMITER);
    }

    public List<Long> getLongs(String name, String delimiter) {
        List<String> strings = this.getStrings(name, delimiter);
        ArrayList<Long> longs = new ArrayList<Long>(strings.size());
        for (String value : strings) {
            try {
                long i = Long.parseLong(value);
                longs.add(i);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Collections.unmodifiableList(longs);
    }

    public List<Float> getFloats(String name) {
        return this.getFloats(name, DEFAULT_LIST_DELIMITER);
    }

    public List<Float> getFloats(String name, String delimiter) {
        List<String> strings = this.getStrings(name, delimiter);
        ArrayList<Float> floats = new ArrayList<Float>(strings.size());
        for (String value : strings) {
            try {
                float i = Float.parseFloat(value);
                floats.add(Float.valueOf(i));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Collections.unmodifiableList(floats);
    }

    public List<Double> getDoubles(String name) {
        return this.getDoubles(name, DEFAULT_LIST_DELIMITER);
    }

    public List<Double> getDoubles(String name, String delimiter) {
        List<String> strings = this.getStrings(name, delimiter);
        ArrayList<Double> doubles = new ArrayList<Double>(strings.size());
        for (String value : strings) {
            try {
                double i = Double.parseDouble(value);
                doubles.add(i);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Collections.unmodifiableList(doubles);
    }

    public long getDurationInMilliseconds(String name) {
        return this.getDurationInMilliseconds(name, 0L);
    }

    public long getDurationInMilliseconds(String name, long defaultValue) {
        TimeUnit timeUnit = this.extractTimeUnit(name, defaultValue + " MILLISECONDS");
        long duration = this.getLong(name, defaultValue);
        return timeUnit.toMillis(duration);
    }

    public long getDurationInSeconds(String name) {
        return this.getDurationInSeconds(name, 0L);
    }

    public long getDurationInSeconds(String name, long defaultValue) {
        TimeUnit timeUnit = this.extractTimeUnit(name, defaultValue + " SECONDS");
        long duration = this.getLong(name, defaultValue);
        return timeUnit.toSeconds(duration);
    }

    public long getDurationInMinutes(String name) {
        return this.getDurationInMinutes(name, 0L);
    }

    public long getDurationInMinutes(String name, long defaultValue) {
        TimeUnit timeUnit = this.extractTimeUnit(name, defaultValue + " MINUTES");
        long duration = this.getLong(name, defaultValue);
        return timeUnit.toMinutes(duration);
    }

    public long getDurationInHours(String name) {
        return this.getDurationInHours(name, 0L);
    }

    public long getDurationInHours(String name, long defaultValue) {
        TimeUnit timeUnit = this.extractTimeUnit(name, defaultValue + " HOURS");
        long duration = this.getLong(name, defaultValue);
        return timeUnit.toHours(duration);
    }

    public long getDurationInDays(String name) {
        return this.getDurationInDays(name, 0L);
    }

    public long getDurationInDays(String name, long defaultValue) {
        TimeUnit timeUnit = this.extractTimeUnit(name, defaultValue + " DAYS");
        long duration = this.getLong(name, defaultValue);
        return timeUnit.toDays(duration);
    }

    private TimeUnit extractTimeUnit(String name, String defaultValue) {
        String value = this.getString(name, defaultValue);
        try {
            String[] s = value.split(" ", 2);
            return TimeUnit.valueOf(s[1].trim().toUpperCase());
        }
        catch (Exception e) {
            throw new PippoRuntimeException("{} must have format '<n> <TimeUnit>' where <TimeUnit> is one of 'MILLISECONDS', 'SECONDS', 'MINUTES', 'HOURS', 'DAYS'", name);
        }
    }

    public boolean hasSetting(String name) {
        return this.getString(name, null) != null;
    }

    public void overrideSetting(String name, boolean value) {
        this.overrides.put(name, Boolean.toString(value));
    }

    public void overrideSetting(String name, String value) {
        this.overrides.put(name, value);
    }

    public void overrideSetting(String name, char value) {
        this.overrides.put(name, Character.toString(value));
    }

    public void overrideSetting(String name, int value) {
        this.overrides.put(name, Integer.toString(value));
    }

    public void overrideSetting(String name, long value) {
        this.overrides.put(name, Long.toString(value));
    }

    public void overrideSetting(String name, float value) {
        this.overrides.put(name, Float.toString(value));
    }

    public void overrideSetting(String name, double value) {
        this.overrides.put(name, Double.toString(value));
    }
}

