/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZipResponseStream
extends ServletOutputStream {
    private HttpServletResponse response;
    private ByteArrayOutputStream byteArrayOutputStream;
    private GZIPOutputStream gzipOutputStream;
    private boolean closed;

    public GZipResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.gzipOutputStream = new GZIPOutputStream(this.byteArrayOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        try (ServletOutputStream outputStream = this.response.getOutputStream();){
            this.gzipOutputStream.finish();
            byte[] bytes = this.byteArrayOutputStream.toByteArray();
            this.response.addHeader("Content-Length", Integer.toString(bytes.length));
            this.response.addHeader("Content-Encoding", "gzip");
            outputStream.write(bytes);
            outputStream.flush();
        }
        finally {
            this.gzipOutputStream.close();
            this.closed = true;
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        this.gzipOutputStream.flush();
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipOutputStream.write((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipOutputStream.write(b, off, len);
    }
}

