/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.reload;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadWatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReloadWatcher.class);
    private static final Map<WatchEvent.Kind<Path>, Event> EVENT_MAP = new HashMap<WatchEvent.Kind<Path>, Event>(){
        {
            this.put(StandardWatchEventKinds.ENTRY_CREATE, Event.ENTRY_CREATE);
            this.put(StandardWatchEventKinds.ENTRY_MODIFY, Event.ENTRY_MODIFY);
            this.put(StandardWatchEventKinds.ENTRY_DELETE, Event.ENTRY_DELETE);
        }
    };
    private final Set<Path> dirPaths;
    private Listener listener;
    private ExecutorService executorService;
    private Future<?> watcherTask;
    private WatchService watchService;
    private Map<WatchKey, Path> watchKeyToDirectory;
    private boolean running;

    private ReloadWatcher(Set<Path> dirPaths, Listener listener) {
        this.dirPaths = dirPaths;
        this.listener = listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.watcherTask = this.executorService.submit(this);
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.executorService.shutdownNow();
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                log.error("Cannot close the watch service", (Throwable)e);
            }
            this.watcherTask.cancel(true);
            this.watcherTask = null;
        }
    }

    @Override
    public void run() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while creating watch service", e);
        }
        this.watchKeyToDirectory = new HashMap<WatchKey, Path>();
        for (Path dir : this.dirPaths) {
            try {
                this.registerDirectory(dir);
            }
            catch (IOException e) {
                log.error("Not watching '{}'", (Object)dir, (Object)e);
            }
        }
        while (this.running) {
            WatchKey key;
            Path dir;
            if (Thread.interrupted()) {
                log.info("Directory watcher thread interrupted");
                break;
            }
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            dir = this.watchKeyToDirectory.get(key);
            if (dir == null) {
                log.warn("Watch key not recognized");
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.kind().equals(StandardWatchEventKinds.OVERFLOW)) break;
                WatchEvent<?> pathEvent = event;
                WatchEvent.Kind<?> kind = pathEvent.kind();
                Path path = dir.resolve((Path)pathEvent.context());
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    try {
                        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                            this.registerDirectory(dir);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!this.running || !EVENT_MAP.containsKey(kind)) continue;
                this.listener.onEvent(EVENT_MAP.get(kind), dir, (Path)pathEvent.context());
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.watchKeyToDirectory.remove(key);
            if (!this.watchKeyToDirectory.isEmpty()) continue;
            break;
        }
    }

    private void registerDirectory(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchKey key = dir.register(ReloadWatcher.this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                ReloadWatcher.this.watchKeyToDirectory.put(key, dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static class Builder {
        private Set<Path> dirPaths = new HashSet<Path>();
        private ExecutorService executorService;

        public Builder addDirectory(String dirPath) {
            return this.addDirectory(Paths.get(dirPath, new String[0]));
        }

        public Builder addDirectory(Path dirPath) {
            this.dirPaths.add(dirPath);
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ReloadWatcher build(Listener listener) {
            ReloadWatcher watcher = new ReloadWatcher(this.dirPaths, listener);
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadExecutor();
            }
            watcher.executorService = this.executorService;
            return watcher;
        }
    }

    public static interface Listener {
        public void onEvent(Event var1, Path var2, Path var3);
    }

    public static enum Event {
        ENTRY_CREATE,
        ENTRY_MODIFY,
        ENTRY_DELETE;

    }
}

