/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.route.UrlResourceHandler;

public class ClasspathResourceHandler
extends UrlResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(ClasspathResourceHandler.class);
    protected final String resourceBasePath;

    public ClasspathResourceHandler(String urlPath, String resourceBasePath) {
        super(urlPath);
        this.resourceBasePath = this.getNormalizedPath(resourceBasePath);
    }

    @Override
    public URL getResourceUrl(String resourcePath) {
        if (!this.isValidResourcePath(this.resourceBasePath, resourcePath)) {
            log.warn("Request for '{}' which is not located in '{}'", (Object)resourcePath, (Object)this.resourceBasePath);
            return null;
        }
        String resourceName = this.getResourceBasePath() + "/" + resourcePath;
        return this.getClass().getClassLoader().getResource(resourceName);
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    protected boolean isValidResourcePath(String resourceBasePath, String resourcePath) {
        Path requestedPath = Paths.get(resourceBasePath, new String[0]).resolve(resourcePath).normalize();
        return requestedPath.startsWith(resourceBasePath);
    }
}

