/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.util.StringUtils;

public class CorsHandler
implements RouteHandler<RouteContext> {
    private String allowOrigin;
    private String exposeHeaders;
    private int maxAge = -1;
    private boolean allowCredentials;
    private String allowMethods;
    private String allowHeaders;

    public CorsHandler(String allowOrigin) {
        if (StringUtils.isNullOrEmpty(allowOrigin)) {
            throw new PippoRuntimeException("allowOrigin cannot be blank", new Object[0]);
        }
        this.allowOrigin = allowOrigin;
    }

    @Override
    public void handle(RouteContext context) {
        Response response = context.getResponse();
        response.header("Access-Control-Allow-Origin", this.allowOrigin);
        if (this.exposeHeaders != null) {
            response.header("Access-Control-Expose-Headers", this.exposeHeaders);
        }
        if (this.maxAge != -1) {
            response.header("Access-Control-Max-Age", "" + this.maxAge);
        }
        if (this.allowCredentials) {
            response.header("Access-Control-Allow-Credentials", "true");
        }
        if (this.allowMethods != null) {
            response.header("Access-Control-Allow-Methods", this.allowMethods);
        }
        if (this.allowHeaders != null) {
            response.header("Access-Control-Allow-Headers", this.allowHeaders);
        }
        if (context.getRequestMethod().equals("OPTIONS")) {
            response.accepted();
            return;
        }
        context.next();
    }

    public CorsHandler exposeHeaders(String exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
        return this;
    }

    public CorsHandler maxAge(int maxAgeInSeconds) {
        this.maxAge = maxAgeInSeconds;
        return this;
    }

    public CorsHandler allowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public CorsHandler allowMethods(String allowMethods) {
        this.allowMethods = allowMethods;
        return this;
    }

    public CorsHandler allowHeaders(String allowHeaders) {
        this.allowHeaders = allowHeaders;
        return this;
    }
}

