/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.DefaultUriMatcher;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.UriMatcher;
import ro.pippo.core.route.ClasspathResourceHandler;
import ro.pippo.core.route.ResourceHandler;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteGroup;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.route.RouteMatch;
import ro.pippo.core.route.RouteTransformer;
import ro.pippo.core.route.Router;
import ro.pippo.core.util.Stack;
import ro.pippo.core.util.StringUtils;

public class DefaultRouter
implements Router {
    private static final Logger log = LoggerFactory.getLogger(DefaultRouter.class);
    private List<Route> routes = new LinkedList<Route>();
    private List<Route> compiledRoutes = new LinkedList<Route>();
    private List<RouteTransformer> transformers = new ArrayList<RouteTransformer>();
    private Set<String> ignorePaths = new TreeSet<String>();
    private String contextPath = "";
    private String applicationPath = "";
    private Map<String, List<Route>> routesCache = new HashMap<String, List<Route>>();
    private Map<String, List<Route>> compiledRoutesCache = new HashMap<String, List<Route>>();
    private UriMatcher uriMatcher = new DefaultUriMatcher(){

        @Override
        protected String getPathParameterValue(String uriPattern, String parameterName, Object parameterValue) {
            ResourceHandler resourceHandler;
            String value = super.getPathParameterValue(uriPattern, parameterName, parameterValue);
            Route compiledRoute = DefaultRouter.this.compiledRoutes.stream().filter(route -> uriPattern.equals(route.getUriPattern())).findAny().orElseThrow(() -> new PippoRuntimeException("Cannot find a compiled route for '{}'", uriPattern));
            RouteHandler handler = compiledRoute.getRouteHandler();
            boolean isResourceRoute = ResourceHandler.class.isAssignableFrom(handler.getClass());
            if (isResourceRoute && "path".equals(parameterName) && (resourceHandler = (ResourceHandler)compiledRoute.getRouteHandler()).isVersioned()) {
                value = resourceHandler.injectVersion(value);
            }
            return value;
        }
    };

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = StringUtils.isNullOrEmpty(contextPath) || "/".equals(contextPath.trim()) ? "" : StringUtils.addStart(contextPath, "/");
    }

    protected String prefixApplicationPath(String path) {
        return this.applicationPath + StringUtils.addStart(path, "/");
    }

    @Override
    public Set<String> getIgnorePaths() {
        return this.ignorePaths;
    }

    @Override
    public void ignorePaths(String ... pathPrefixes) {
        for (String pathPrefix : pathPrefixes) {
            this.ignorePaths.add(StringUtils.addStart(pathPrefix, "/"));
        }
    }

    @Override
    public final List<Route> getRoutes() {
        ArrayList<Route> allRoutes = new ArrayList<Route>();
        allRoutes.addAll(this.routes);
        allRoutes.addAll(this.compiledRoutes);
        return Collections.unmodifiableList(allRoutes);
    }

    @Override
    public void compileRoutes() {
        if (this.routes.isEmpty()) {
            return;
        }
        log.debug("Compile routes");
        Iterator<Route> it = this.routes.iterator();
        while (it.hasNext()) {
            RouteTransformer transformer;
            Route route = it.next();
            it.remove();
            List<Route> cacheEntry = this.routesCache.get(route.getRequestMethod());
            if (cacheEntry != null) {
                cacheEntry.remove(route);
            }
            Route compiledRoute = this.compileRoute(route);
            Iterator<RouteTransformer> iterator = this.transformers.iterator();
            while (iterator.hasNext() && (compiledRoute = (transformer = iterator.next()).transform(compiledRoute)) != null) {
                compiledRoute.bind("__transformer", transformer);
            }
            if (compiledRoute == null) continue;
            this.addCompiledRoute(compiledRoute);
        }
    }

    public List<Route> getRoutes(String requestMethod) {
        ArrayList<Route> allRoutes = new ArrayList<Route>();
        if (this.routesCache.containsKey(requestMethod)) {
            allRoutes.addAll((Collection)this.routesCache.get(requestMethod));
        }
        allRoutes.addAll(this.getCompiledRoutes(requestMethod));
        return Collections.unmodifiableList(allRoutes);
    }

    @Override
    public List<RouteMatch> findRoutes(String requestMethod, String requestUri) {
        log.trace("Finding route matches for {} '{}'", (Object)requestMethod, (Object)requestUri);
        this.compileRoutes();
        ArrayList<RouteMatch> routeMatches = new ArrayList<RouteMatch>();
        for (Route route : this.compiledRoutes) {
            String uriPattern;
            Map<String, String> parameters;
            boolean methodMatches = route.getRequestMethod().equals(requestMethod) || route.getRequestMethod().equals("ANY");
            if (!methodMatches || (parameters = this.uriMatcher.match(requestUri, uriPattern = route.getUriPattern())) == null) continue;
            routeMatches.add(new RouteMatch(route, parameters));
        }
        log.debug("Found {} route matches for {} '{}'", new Object[]{routeMatches.size(), requestMethod, requestUri});
        return routeMatches;
    }

    @Override
    public void addRoute(Route route) {
        log.debug("Add route for {} '{}'", (Object)route.getRequestMethod(), (Object)route.getUriPattern());
        this.validateRoute(route);
        this.routes.add(route);
        List<Route> cacheEntry = this.routesCache.get(route.getRequestMethod());
        if (cacheEntry == null) {
            cacheEntry = new ArrayList<Route>();
        }
        cacheEntry.add(route);
        this.routesCache.put(route.getRequestMethod(), cacheEntry);
    }

    @Override
    public void removeRoute(Route route) {
        log.debug("Removing route for {} '{}'", (Object)route.getRequestMethod(), (Object)route.getUriPattern());
        boolean removed = this.routes.remove(route);
        if (removed) {
            List<Route> cacheEntry = this.routesCache.get(route.getRequestMethod());
            if (cacheEntry != null) {
                cacheEntry.remove(route);
            }
            this.removeCompiledRoute(route);
        }
    }

    @Override
    public void addRouteGroup(RouteGroup routeGroup) {
        routeGroup.getRoutes().forEach(route -> {
            String uriPattern = routeGroup.getUriPattern();
            Stack<String> nameStack = new Stack<String>();
            nameStack.push(route.getName());
            nameStack.pushIfNotEmpty(routeGroup.getName());
            Stack<Map<String, Object>> attributesStack = new Stack<Map<String, Object>>();
            attributesStack.push(route.getAttributes());
            attributesStack.push(routeGroup.getAttributes());
            for (RouteGroup parent = routeGroup.getParent(); parent != null; parent = parent.getParent()) {
                uriPattern = this.concatUriPattern(parent.getUriPattern(), uriPattern);
                nameStack.pushIfNotEmpty(parent.getName());
                attributesStack.push(parent.getAttributes());
            }
            route.setAbsoluteUriPattern(this.concatUriPattern(uriPattern, route.getUriPattern()));
            if (!nameStack.isEmpty()) {
                route.setName(StreamSupport.stream(nameStack.spliterator(), false).collect(Collectors.joining("")));
            }
            if (!attributesStack.isEmpty()) {
                route.bindAll(StreamSupport.stream(attributesStack.spliterator(), false).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            this.addRoute((Route)route);
        });
        routeGroup.getChildren().forEach(this::addRouteGroup);
    }

    @Override
    public void removeRouteGroup(RouteGroup routeGroup) {
        routeGroup.getRoutes().forEach(this::removeRoute);
        routeGroup.getChildren().forEach(this::removeRouteGroup);
    }

    @Override
    public String uriFor(String relativeUri) {
        return this.prefixApplicationPath(relativeUri);
    }

    @Override
    public String uriFor(String nameOrUriPattern, Map<String, Object> parameters) {
        this.compileRoutes();
        Route compiledRoute = this.getCompiledRoute(nameOrUriPattern);
        if (compiledRoute == null) {
            return null;
        }
        return this.prefixApplicationPath(this.uriMatcher.uriFor(compiledRoute.getUriPattern(), parameters));
    }

    @Override
    public String uriPatternFor(Class<? extends ResourceHandler> resourceHandlerClass) {
        Route route = this.getRoute(resourceHandlerClass);
        return route != null ? route.getUriPattern() : null;
    }

    @Override
    public String getApplicationPath() {
        return this.applicationPath;
    }

    @Override
    public void setApplicationPath(String applicationPath) {
        this.applicationPath = StringUtils.isNullOrEmpty(applicationPath) || "/".equals(applicationPath.trim()) ? "" : StringUtils.removeEnd(StringUtils.addStart(applicationPath, "/"), "/");
    }

    @Override
    public void addRouteTransformer(RouteTransformer transformer) {
        log.debug("Add transformer '{}'", (Object)transformer.getClass().getSimpleName());
        this.transformers.add(transformer);
    }

    @Override
    public List<RouteTransformer> getRouteTransformers() {
        return this.transformers;
    }

    protected void validateRoute(Route route) {
        if (StringUtils.isNullOrEmpty(route.getRequestMethod())) {
            throw new PippoRuntimeException("Unspecified request method!", new Object[0]);
        }
        String uriPattern = route.getUriPattern();
        if (StringUtils.isNullOrEmpty(uriPattern)) {
            throw new PippoRuntimeException("The uri pattern cannot be null or empty", new Object[0]);
        }
    }

    private Route getRoute(Class<? extends ResourceHandler> resourceHandlerClass) {
        List<Route> routes = this.getRoutes();
        for (Route route : routes) {
            ClasspathResourceHandler resourceHandler;
            RouteHandler routeHandler = route.getRouteHandler();
            if (!resourceHandlerClass.isAssignableFrom(routeHandler.getClass()) || resourceHandlerClass != (resourceHandler = (ClasspathResourceHandler)routeHandler).getClass()) continue;
            return route;
        }
        return null;
    }

    private Route compileRoute(Route route) {
        String uriPattern = route.getUriPattern();
        UriMatcher.UriPatternBinding binding = this.uriMatcher.addUriPattern(uriPattern);
        List<String> parameterNames = binding.getParameterNames();
        Route compiledRoute = new Route(route);
        compiledRoute.bind("__pattern", binding.getPattern());
        compiledRoute.bind("__parameterNames", parameterNames);
        return compiledRoute;
    }

    private void addCompiledRoute(Route compiledRoute) {
        this.compiledRoutes.add(compiledRoute);
        String requestMethod = compiledRoute.getRequestMethod();
        if (!this.compiledRoutesCache.containsKey(requestMethod)) {
            this.compiledRoutesCache.put(requestMethod, new ArrayList());
        }
        this.compiledRoutesCache.get(requestMethod).add(compiledRoute);
    }

    private void removeCompiledRoute(Route route) {
        String nameOrUriPattern = StringUtils.isNullOrEmpty(route.getName()) ? route.getUriPattern() : route.getName();
        Route compiledRoute = this.getCompiledRoute(nameOrUriPattern);
        if (compiledRoute == null) {
            return;
        }
        this.compiledRoutes.remove(compiledRoute);
        List<Route> cacheEntry = this.compiledRoutesCache.get(route.getRequestMethod());
        if (cacheEntry != null) {
            cacheEntry.remove(compiledRoute);
        }
        this.uriMatcher.removeUriPattern(compiledRoute.getUriPattern());
    }

    private Route getCompiledRoute(String nameOrUriPattern) {
        for (Route route : this.compiledRoutes) {
            if (!nameOrUriPattern.equals(route.getName()) && !nameOrUriPattern.equals(route.getUriPattern())) continue;
            return route;
        }
        return null;
    }

    private List<Route> getCompiledRoutes(String requestMethod) {
        ArrayList<Route> compiledRoutes = new ArrayList<Route>();
        if (this.compiledRoutesCache.containsKey(requestMethod)) {
            compiledRoutes.addAll((Collection<Route>)this.compiledRoutesCache.get(requestMethod));
        }
        return compiledRoutes;
    }

    private String concatUriPattern(String prefix, String uriPattern) {
        return "/".equals(uriPattern = StringUtils.addStart(StringUtils.addStart(uriPattern, "/"), prefix)) ? uriPattern : StringUtils.removeEnd(uriPattern, "/");
    }
}

