/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Languages;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.util.StringUtils;

public class LanguageHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(LanguageHandler.class);
    protected final Languages languages;
    protected final boolean enableQueryParameter;
    protected final boolean setCookie;

    public LanguageHandler(Languages languages, boolean enableQueryParameter, boolean setCookie) {
        this.languages = languages;
        this.enableQueryParameter = enableQueryParameter;
        this.setCookie = setCookie;
    }

    public void handle(RouteContext routeContext) {
        String language;
        String string = language = this.enableQueryParameter ? routeContext.getParameter("lang").toString() : null;
        if (StringUtils.isNullOrEmpty(language)) {
            language = this.languages.getLanguageOrDefault(routeContext);
        }
        Locale locale = this.languages.getLocaleOrDefault(language);
        routeContext.setLocal("lang", language);
        routeContext.setLocal("locale", locale);
        if (this.setCookie) {
            if (routeContext.getResponse().isCommitted()) {
                log.debug("LANG cookie NOT set, Response already committed!");
            } else {
                this.languages.setLanguageCookie(language, routeContext);
            }
        }
        routeContext.next();
    }
}

