/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.File;
import ro.pippo.core.route.ClasspathResourceHandler;
import ro.pippo.core.route.FileResourceHandler;
import ro.pippo.core.route.PublicResourceHandler;
import ro.pippo.core.route.ResourceHandler;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.Routing;
import ro.pippo.core.route.WebjarsResourceHandler;

public interface ResourceRouting
extends Routing {
    default public Route addPublicResourceRoute() {
        return this.addPublicResourceRoute("/public");
    }

    default public Route addPublicResourceRoute(String urlPath) {
        return this.addResourceRoute(new PublicResourceHandler(urlPath));
    }

    default public Route addFileResourceRoute(String urlPath, File directory) {
        return this.addResourceRoute(new FileResourceHandler(urlPath, directory));
    }

    default public Route addFileResourceRoute(String urlPath, String directory) {
        return this.addResourceRoute(new FileResourceHandler(urlPath, directory));
    }

    default public Route addClasspathResourceRoute(String urlPath, Class<?> resourceClass) {
        return this.addResourceRoute(new ClasspathResourceHandler(urlPath, resourceClass.getName().replace(".", "/")));
    }

    default public Route addClasspathResourceRoute(String urlPath, String resourceBasePath) {
        return this.addResourceRoute(new ClasspathResourceHandler(urlPath, resourceBasePath));
    }

    default public Route addWebjarsResourceRoute() {
        return this.addWebjarsResourceRoute("/webjars");
    }

    default public Route addWebjarsResourceRoute(String urlPath) {
        return this.addResourceRoute(new WebjarsResourceHandler(urlPath));
    }

    default public Route addResourceRoute(ResourceHandler resourceHandler) {
        Route route = Route.GET(resourceHandler.getUriPattern(), resourceHandler);
        this.addRoute(route);
        return route;
    }
}

