/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.RouteHandler;

public class Route {
    private String requestMethod;
    private String uriPattern;
    private RouteHandler routeHandler;
    private String absoluteUriPattern;
    private boolean runAsFinally;
    private String name;
    private Map<String, Object> attributes;

    public Route(String requestMethod, String uriPattern, RouteHandler routeHandler) {
        this.requestMethod = requestMethod;
        this.uriPattern = uriPattern;
        this.setRouteHandler(routeHandler);
        this.attributes = new HashMap<String, Object>();
    }

    public Route(Route route) {
        this.requestMethod = route.requestMethod;
        this.uriPattern = route.uriPattern;
        this.routeHandler = route.routeHandler;
        this.absoluteUriPattern = route.absoluteUriPattern;
        this.attributes = new HashMap<String, Object>(route.attributes);
        this.name = route.name;
        this.runAsFinally = route.runAsFinally;
    }

    public static Route GET(String uriPattern, RouteHandler routeHandler) {
        return new Route("GET", uriPattern, routeHandler);
    }

    public static Route POST(String uriPattern, RouteHandler routeHandler) {
        return new Route("POST", uriPattern, routeHandler);
    }

    public static Route DELETE(String uriPattern, RouteHandler routeHandler) {
        return new Route("DELETE", uriPattern, routeHandler);
    }

    public static Route HEAD(String uriPattern, RouteHandler routeHandler) {
        return new Route("HEAD", uriPattern, routeHandler);
    }

    public static Route PUT(String uriPattern, RouteHandler routeHandler) {
        return new Route("PUT", uriPattern, routeHandler);
    }

    public static Route PATCH(String uriPattern, RouteHandler routeHandler) {
        return new Route("PATCH", uriPattern, routeHandler);
    }

    public static Route OPTIONS(String uriPattern, RouteHandler routeHandler) {
        return new Route("OPTIONS", uriPattern, routeHandler);
    }

    public static Route CONNECT(String uriPattern, RouteHandler routeHandler) {
        return new Route("CONNECT", uriPattern, routeHandler);
    }

    @Deprecated
    public static Route ALL(String uriPattern, RouteHandler routeHandler) {
        return Route.ANY(uriPattern, routeHandler);
    }

    public static Route ANY(String uriPattern, RouteHandler routeHandler) {
        return new Route("ANY", uriPattern, routeHandler);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getUriPattern() {
        return this.absoluteUriPattern != null ? this.absoluteUriPattern : this.uriPattern;
    }

    public RouteHandler getRouteHandler() {
        return this.routeHandler;
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        if (routeHandler == null) {
            throw new IllegalArgumentException("Route handler cannot be null");
        }
        this.routeHandler = routeHandler;
    }

    public boolean isRunAsFinally() {
        return this.runAsFinally;
    }

    public void runAsFinally() {
        this.runAsFinally = true;
    }

    public String getName() {
        return this.name;
    }

    public Route named(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Route bind(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public Route bindAll(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public void setAbsoluteUriPattern(String absoluteUriPattern) {
        if (this.absoluteUriPattern != null) {
            throw new PippoRuntimeException("This route is already in a group", new Object[0]);
        }
        this.absoluteUriPattern = absoluteUriPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        return this.requestMethod.equals(route.requestMethod) && this.getUriPattern().equals(route.getUriPattern());
    }

    public int hashCode() {
        int result = this.uriPattern.hashCode();
        result = 31 * result + this.requestMethod.hashCode();
        return result;
    }

    public String toString() {
        return "Route{requestMethod='" + this.requestMethod + '\'' + ", uriPattern='" + this.getUriPattern() + '\'' + '}';
    }
}

