/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.ErrorHandler;
import ro.pippo.core.Flash;
import ro.pippo.core.Request;
import ro.pippo.core.Response;
import ro.pippo.core.route.DefaultRouteContextFactory;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteContextFactory;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.route.RouteMatch;
import ro.pippo.core.route.Router;
import ro.pippo.core.util.ServiceLocator;

public class RouteDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RouteDispatcher.class);
    private static final ThreadLocal<RouteContext> ROUTE_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private static final List<RouteMatch> noMatches = Collections.emptyList();
    private RouteContextFactory<?> routeContextFactory;
    private Application application;
    private Router router;
    private ErrorHandler errorHandler;
    private RouteHandler notFoundRouteHandler;

    public static <T extends RouteContext> T getRouteContext() {
        return (T)ROUTE_CONTEXT_THREAD_LOCAL.get();
    }

    public RouteDispatcher(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public void init() {
        log.debug("Initializing application '{}'", (Object)this.application);
        this.application.init();
        this.router = this.application.getRouter();
        this.errorHandler = this.application.getErrorHandler();
        this.notFoundRouteHandler = this.application.getNotFoundRouteHandler();
        this.routeContextFactory = this.getRouteContextFactory();
        this.routeContextFactory.init(this.application);
        log.debug("RouteContext factory is '{}'", (Object)this.routeContextFactory.getClass().getName());
    }

    protected RouteContextFactory<?> getRouteContextFactory() {
        RouteContextFactory factory = ServiceLocator.locate(RouteContextFactory.class);
        if (factory == null) {
            factory = new DefaultRouteContextFactory();
        }
        return factory;
    }

    public void dispatch(Request request, Response response) throws IOException, ServletException {
        this.onPreDispatch(request, response);
        this.onRouteDispatch(request, response);
        this.onPostDispatch(request, response);
    }

    protected void onPreDispatch(Request request, Response response) {
        this.application.getRoutePreDispatchListeners().onPreDispatch(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRouteDispatch(Request request, Response response) {
        String requestPath = request.getPath();
        String requestMethod = request.getMethod();
        if (this.shouldIgnorePath(requestPath)) {
            Object routeContext = this.routeContextFactory.createRouteContext(this.application, request, response, noMatches);
            ROUTE_CONTEXT_THREAD_LOCAL.set((RouteContext)routeContext);
            this.errorHandler.handle(404, (RouteContext)routeContext);
            ROUTE_CONTEXT_THREAD_LOCAL.remove();
            log.debug("Returned status code {} for {} '{}' (IGNORED)", new Object[]{response.getStatus(), requestMethod, requestPath});
            return;
        }
        List<RouteMatch> routeMatches = this.router.findRoutes(requestMethod, requestPath);
        Object routeContext = this.routeContextFactory.createRouteContext(this.application, request, response, routeMatches);
        ROUTE_CONTEXT_THREAD_LOCAL.set((RouteContext)routeContext);
        try {
            if (routeMatches.isEmpty()) {
                if (this.notFoundRouteHandler != null) {
                    this.notFoundRouteHandler.handle(routeContext);
                } else {
                    this.errorHandler.handle(404, (RouteContext)routeContext);
                }
            } else {
                this.processFlash((RouteContext)routeContext);
            }
            routeContext.next();
            if (!response.isCommitted()) {
                if (response.getStatus() == 0) {
                    log.debug("Status code not set for {} '{}'", (Object)requestMethod, (Object)requestPath);
                    response.notFound();
                }
                log.debug("Auto-committing response for {} '{}'", (Object)requestMethod, (Object)requestPath);
                if (response.getStatus() >= 400) {
                    this.errorHandler.handle(response.getStatus(), (RouteContext)routeContext);
                } else {
                    response.commit();
                }
            }
            routeContext.runFinallyRoutes();
        }
        catch (Exception e) {
            try {
                this.errorHandler.handle(e, (RouteContext)routeContext);
                routeContext.runFinallyRoutes();
            }
            catch (Throwable throwable) {
                routeContext.runFinallyRoutes();
                log.debug("Returned status code {} for {} '{}'", new Object[]{response.getStatus(), requestMethod, requestPath});
                ROUTE_CONTEXT_THREAD_LOCAL.remove();
                throw throwable;
            }
            log.debug("Returned status code {} for {} '{}'", new Object[]{response.getStatus(), requestMethod, requestPath});
            ROUTE_CONTEXT_THREAD_LOCAL.remove();
        }
        log.debug("Returned status code {} for {} '{}'", new Object[]{response.getStatus(), requestMethod, requestPath});
        ROUTE_CONTEXT_THREAD_LOCAL.remove();
    }

    protected void onPostDispatch(Request request, Response response) {
        this.application.getRoutePostDispatchListeners().onPostDispatch(request, response);
    }

    protected boolean shouldIgnorePath(String requestUri) {
        for (String path : this.router.getIgnorePaths()) {
            if (!requestUri.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private void processFlash(RouteContext routeContext) {
        Flash flash = null;
        if (routeContext.hasSession()) {
            flash = (Flash)routeContext.removeSession("flash");
            routeContext.setSession("flash", new Flash());
        }
        if (flash == null) {
            flash = new Flash();
        }
        routeContext.setLocal("flash", flash);
    }
}

