/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class SystemInfoHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoHandler.class);

    public void handle(RouteContext routeContext) {
        Response response = routeContext.getResponse().noCache().text();
        HashMap<String, String> props = new HashMap<String, String>();
        for (String name : System.getProperties().stringPropertyNames()) {
            props.put(name, System.getProperty(name));
        }
        try (BufferedWriter writer = new BufferedWriter(response.getWriter());){
            this.writeSystemProperties(props, writer);
            writer.newLine();
            this.writeEnv(System.getenv(), writer);
            writer.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeSystemProperties(Map<String, String> props, BufferedWriter writer) throws IOException {
        this.writeBanner("System properties", writer);
        this.writeProperties(props, writer);
    }

    protected void writeEnv(Map<String, String> env, BufferedWriter writer) throws IOException {
        this.writeBanner("Environment", writer);
        this.writeProperties(env, writer);
    }

    protected void writeBanner(String banner, BufferedWriter writer) throws IOException {
        writer.write("### " + banner + " ###");
        writer.newLine();
    }

    protected void writeProperties(Map<String, String> map, BufferedWriter writer) throws IOException {
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        for (String key : keys) {
            writer.write(key + " = " + map.get(key));
            writer.newLine();
        }
    }
}

