/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.ClasspathResourceHandler;
import ro.pippo.core.util.ClasspathUtils;
import ro.pippo.core.util.CryptoUtils;

public class WebjarsResourceHandler
extends ClasspathResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(WebjarsResourceHandler.class);
    private final Map<String, String> pathAliases = this.indexWebjars();

    public WebjarsResourceHandler() {
        this("/webjars");
    }

    public WebjarsResourceHandler(String urlPath) {
        super(urlPath, "META-INF/resources/webjars");
    }

    @Override
    public URL getResourceUrl(String resourcePath) {
        URL url;
        String artifactVersion;
        if (!this.isValidResourcePath(this.resourceBasePath, resourcePath)) {
            log.warn("Request for '{}' which is not located in '{}'", (Object)resourcePath, (Object)this.resourceBasePath);
            return null;
        }
        String resourceName = this.getResourceBasePath() + "/" + resourcePath;
        String artifactPath = resourcePath.substring(0, resourcePath.indexOf(47) + 1);
        if (this.pathAliases.containsKey(artifactPath) && !resourcePath.startsWith(artifactVersion = this.pathAliases.get(artifactPath))) {
            String aliasedPath = artifactVersion + resourcePath.substring(artifactPath.length());
            log.trace("Replaced Webjar path {} with {}", (Object)resourcePath, (Object)aliasedPath);
            resourceName = this.getResourceBasePath() + "/" + aliasedPath;
        }
        if ((url = this.getClass().getClassLoader().getResource(resourceName)) == null) {
            log.warn("Resource '{}' not found", (Object)resourceName);
        }
        return url;
    }

    @Override
    protected String getResourceVersion(String resourcePath) {
        String artifactVersion;
        String artifactPath = resourcePath.substring(0, resourcePath.indexOf(47) + 1);
        if (this.pathAliases.containsKey(artifactPath) && !resourcePath.startsWith(artifactVersion = this.pathAliases.get(artifactPath))) {
            return CryptoUtils.getHashMD5(artifactVersion);
        }
        return null;
    }

    private Map<String, String> indexWebjars() {
        TreeMap<String, String> pathAliases = new TreeMap<String, String>();
        for (String string : this.locatePomProperties()) {
            log.debug("Parsing Webjars metadata {}", (Object)string);
            URL url = ClasspathUtils.locateOnClasspath(string);
            Properties pom = new Properties();
            try (InputStream is = url.openStream();){
                pom.load(is);
            }
            catch (IOException e) {
                log.error("Failed to read {}", (Object)url);
                continue;
            }
            String artifactId = pom.getProperty("artifactId");
            String version = pom.getProperty("version");
            String fixedPath = artifactId + '/' + version + '/';
            String aliasPath = artifactId + '/';
            pathAliases.put(aliasPath, fixedPath);
        }
        for (Map.Entry entry : pathAliases.entrySet()) {
            log.debug("Registered Webjars path alias '{}' => '{}'", entry.getKey(), entry.getValue());
        }
        return pathAliases;
    }

    private List<String> locatePomProperties() {
        ArrayList<String> propertiesFiles = new ArrayList<String>();
        List<URL> packageUrls = ClasspathUtils.getResources(this.getResourceBasePath());
        for (URL packageUrl : packageUrls) {
            if (!packageUrl.getProtocol().equals("jar")) continue;
            log.debug("Scanning {}", (Object)packageUrl);
            try {
                String jar = packageUrl.toString().substring("jar:".length()).split("!")[0];
                File file = new File(new URI(jar));
                JarInputStream is = new JarInputStream(new FileInputStream(file));
                Throwable throwable = null;
                try {
                    JarEntry entry = null;
                    while ((entry = is.getNextJarEntry()) != null) {
                        if (entry.isDirectory() || !entry.getName().endsWith("pom.properties")) continue;
                        propertiesFiles.add(entry.getName());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new PippoRuntimeException("Failed to get classes for package '{}'", packageUrl);
            }
        }
        return propertiesFiles;
    }
}

