/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.DateUtils;
import ro.pippo.core.util.StringUtils;

public class HttpCacheToolkit {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheToolkit.class);
    private final PippoSettings pippoSettings;

    public HttpCacheToolkit(PippoSettings pippoSettings) {
        this.pippoSettings = pippoSettings;
    }

    public boolean isModified(String etag, long lastModified, RouteContext routeContext) {
        String browserEtag = routeContext.getHeader("If-None-Match");
        if (browserEtag != null && !StringUtils.isNullOrEmpty(etag)) {
            return !browserEtag.equals(etag);
        }
        String ifModifiedSince = routeContext.getHeader("If-Modified-Since");
        if (lastModified > 0L && !StringUtils.isNullOrEmpty(ifModifiedSince)) {
            try {
                Date browserDate = DateUtils.parseHttpDateFormat(ifModifiedSince);
                if (browserDate.getTime() >= lastModified) {
                    return false;
                }
            }
            catch (ParseException e) {
                log.warn("Can't parse HTTP date", (Throwable)e);
            }
        }
        return true;
    }

    public void addEtag(RouteContext routeContext, long lastModified) {
        if (this.pippoSettings.isProd()) {
            String maxAge = this.pippoSettings.getString("http.cacheControl", "3600");
            if (maxAge.equals("0")) {
                routeContext.setHeader("Cache-Control", "no-cache");
            } else {
                routeContext.setHeader("Cache-Control", "max-age=" + maxAge);
            }
        } else {
            routeContext.setHeader("Cache-Control", "no-cache");
        }
        String etag = null;
        boolean useEtag = this.pippoSettings.getBoolean("http.useETag", true);
        if (useEtag) {
            etag = "\"" + lastModified + "\"";
            routeContext.setHeader("Etag", etag);
        }
        if (this.isModified(etag, lastModified, routeContext)) {
            routeContext.setHeader("Last-Modified", DateUtils.formatForHttpHeader(lastModified));
        } else if (routeContext.isRequestMethod("GET")) {
            routeContext.status(304);
        }
    }
}

