/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PathRegexBuilder {
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();

    public PathRegexBuilder includes(String ... includes) {
        this.includes.addAll(Arrays.asList(includes));
        return this;
    }

    public PathRegexBuilder excludes(String ... excludes) {
        this.excludes.addAll(Arrays.asList(excludes));
        return this;
    }

    public String build() {
        StringBuilder regex = new StringBuilder();
        StringBuilder regexIncludes = new StringBuilder();
        if (!this.includes.isEmpty()) {
            regexIncludes.append('^');
            regexIncludes.append('(');
            for (String include : this.includes) {
                regexIncludes.append(include);
                regexIncludes.append('|');
            }
            regexIncludes.deleteCharAt(regexIncludes.length() - 1);
            regexIncludes.append(").*");
        }
        if (!this.excludes.isEmpty()) {
            // empty if block
        }
        StringBuilder regexExcludes = new StringBuilder();
        if (!this.excludes.isEmpty()) {
            regexExcludes.append('^');
            regexExcludes.append("(?!");
            for (String exclude : this.excludes) {
                regexExcludes.append(exclude);
                regexExcludes.append('|');
            }
            regexExcludes.deleteCharAt(regexExcludes.length() - 1);
            regexExcludes.append(").+");
        }
        if (regexIncludes.length() == 0) {
            regex.append((CharSequence)regexExcludes);
        } else if (regexExcludes.length() == 0) {
            regex.append((CharSequence)regexIncludes);
        } else {
            regex.append("(?=");
            regex.append((CharSequence)regexIncludes);
            regex.append(')');
            regex.append((CharSequence)regexExcludes);
        }
        return regex.toString();
    }

    public String toString() {
        return "RegexBuilder{includes=" + this.includes + ", excludes=" + this.excludes + '}';
    }
}

