/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLocator {
    private static final Logger log = LoggerFactory.getLogger(ServiceLocator.class);

    private ServiceLocator() {
    }

    public static <T> T locate(Class<T> service) {
        return ServiceLocator.locate(service, service.getClassLoader());
    }

    public static <T> T locate(Class<T> service, ClassLoader classLoader) {
        List<T> services = ServiceLocator.locateAll(service, classLoader);
        return services.isEmpty() ? null : (T)services.get(0);
    }

    public static <T> List<T> locateAll(Class<T> service) {
        return ServiceLocator.locateAll(service, service.getClassLoader());
    }

    public static <T> List<T> locateAll(Class<T> service, ClassLoader classLoader) {
        log.debug("Locate service '{}' using ServiceLoader", (Object)service.getName());
        ServiceLoader<T> loader = ServiceLoader.load(service, classLoader);
        ArrayList<T> services = new ArrayList<T>();
        for (T item : loader) {
            log.debug("Found '{}'", (Object)item.getClass().getName());
            services.add(item);
        }
        return services;
    }
}

