/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import ro.pippo.core.util.IoUtils;

public class WhitelistObjectInputStream
extends ObjectInputStream {
    private static Set<String> whiteClassNames;
    private static Set<Pattern> whiteRegEx;

    public WhitelistObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass descriptor) throws ClassNotFoundException, IOException {
        String className = descriptor.getName();
        if (!this.isWhiteClass(className)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", className);
        }
        return super.resolveClass(descriptor);
    }

    private boolean isWhiteClass(String className) {
        for (String name : whiteClassNames) {
            if (!name.equals(className)) continue;
            return true;
        }
        for (Pattern pattern : whiteRegEx) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    private static void loadWhitelist(InputStream input) {
        String[] lines;
        String content;
        try {
            content = IoUtils.toString(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading the whitelist input", e);
        }
        whiteClassNames = new HashSet<String>();
        whiteRegEx = new HashSet<Pattern>();
        for (String line : lines = content.split("[\\r\\n]+")) {
            if (line.startsWith("#")) continue;
            if (line.startsWith(">")) {
                WhitelistObjectInputStream.addWhiteRegEx(line.substring(1).trim());
                continue;
            }
            WhitelistObjectInputStream.addWhiteClassName(line.trim());
        }
    }

    private static void addWhiteClassName(String className) {
        whiteClassNames.add(className);
    }

    private static void addWhiteRegEx(String regex) {
        whiteRegEx.add(Pattern.compile(regex));
    }

    public static String[] getWhiteClassNames() {
        return whiteClassNames.toArray(new String[0]);
    }

    public static Pattern[] getWhiteRegEx() {
        return whiteRegEx.toArray(new Pattern[0]);
    }

    static {
        WhitelistObjectInputStream.loadWhitelist(WhitelistObjectInputStream.class.getResourceAsStream("/pippo/whitelist-serialization.txt"));
    }
}

