/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.websocket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.websocket.WebSocketContext;

public interface WebSocketHandler {
    public static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);

    public void onMessage(WebSocketContext var1, String var2);

    default public void onMessage(WebSocketContext webSocketContext, byte[] message) {
    }

    default public void onOpen(WebSocketContext webSocketContext) {
        log.debug("Open websocket connection");
    }

    default public void onClose(WebSocketContext webSocketContext, int closeCode, String message) {
        log.debug("Close websocket connection");
    }

    default public void onTimeout(WebSocketContext webSocketContext) {
        log.debug("Timeout websocket connection");
    }

    default public void onError(WebSocketContext webSocketContext, Throwable t) {
        log.error("Error websocket", t);
    }
}

