/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import org.servicemix.components.AbstractComponent;
import org.servicemix.components.ManagementMessageHelper;
import org.servicemix.components.ServiceUnit;

public abstract class AbstractDeployableComponent
extends AbstractComponent
implements ServiceUnitManager {
    protected Map serviceUnits = new ConcurrentHashMap();

    public final ServiceUnitManager getServiceUnitManager() {
        return this;
    }

    public synchronized String deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Deploying service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            if (this.serviceUnits.get(serviceUnitName) != null) {
                throw new DeploymentException(this.createFailureMessage("deploy", "Service Unit '" + serviceUnitName + "' is already deployed"));
            }
            ServiceUnit su = this.doDeploy(serviceUnitName, serviceUnitRootPath);
            this.serviceUnits.put(serviceUnitName, su);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit deployed");
            }
            return this.createSuccessMessage("deploy");
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(this.createFailureMessage("deploy", e));
        }
    }

    protected abstract ServiceUnit doDeploy(String var1, String var2) throws Exception;

    public synchronized void init(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Initializing service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            if (this.serviceUnits.get(serviceUnitName) == null) {
                throw new DeploymentException(this.createFailureMessage("deploy", "Service Unit '" + serviceUnitName + "' is not deployed"));
            }
            this.doInit(serviceUnitName, serviceUnitRootPath);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit initialized");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(this.createFailureMessage("init", e));
        }
    }

    protected void doInit(String serviceUnitName, String serviceUnitRootPath) throws Exception {
    }

    public synchronized void start(String serviceUnitName) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = (ServiceUnit)this.serviceUnits.get(serviceUnitName);
            if (su == null) {
                throw new DeploymentException(this.createFailureMessage("deploy", "Service Unit '" + serviceUnitName + "' is not deployed"));
            }
            if (!"Stopped".equals(su.getCurrentState()) && !"Shutdown".equals(su.getCurrentState())) {
                throw new DeploymentException("ServiceUnit should be in a SHUTDOWN or STOPPED state");
            }
            su.start();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit started");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(this.createFailureMessage("start", e));
        }
    }

    public synchronized void stop(String serviceUnitName) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Stopping service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = (ServiceUnit)this.serviceUnits.get(serviceUnitName);
            if (su == null) {
                throw new DeploymentException(this.createFailureMessage("deploy", "Service Unit '" + serviceUnitName + "' is not deployed"));
            }
            if (!"Running".equals(su.getCurrentState())) {
                throw new DeploymentException("ServiceUnit should be in a SHUTDOWN state");
            }
            su.stop();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit stopped");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(this.createFailureMessage("stop", e));
        }
    }

    public synchronized void shutDown(String serviceUnitName) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = (ServiceUnit)this.serviceUnits.get(serviceUnitName);
            if (su == null) {
                throw new DeploymentException(this.createFailureMessage("deploy", "Service Unit '" + serviceUnitName + "' is not deployed"));
            }
            su.shutDown();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit shut down");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(this.createFailureMessage("shutDown", e));
        }
    }

    public synchronized String undeploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Undeploying service unit");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = (ServiceUnit)this.serviceUnits.get(serviceUnitName);
            if (su == null) {
                throw new DeploymentException(this.createFailureMessage("deploy", "Service Unit '" + serviceUnitName + "' is not deployed"));
            }
            if (!"Shutdown".equals(su.getCurrentState())) {
                throw new DeploymentException("ServiceUnit should be in a SHUTDOWN state");
            }
            this.doUndeploy(su);
            this.serviceUnits.remove(serviceUnitName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit undeployed");
            }
            return this.createSuccessMessage("undeploy");
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(this.createFailureMessage("undeploy", e));
        }
    }

    protected void doUndeploy(ServiceUnit su) throws Exception {
    }

    protected String createSuccessMessage(String task) {
        ManagementMessageHelper.Message msg = new ManagementMessageHelper.Message();
        msg.setComponent(this.context.getComponentName());
        msg.setTask(task);
        msg.setResult("SUCCESS");
        return ManagementMessageHelper.createComponentMessage(msg);
    }

    protected String createFailureMessage(String task, Exception e) {
        ManagementMessageHelper.Message msg = new ManagementMessageHelper.Message();
        msg.setComponent(this.context.getComponentName());
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        return ManagementMessageHelper.createComponentMessage(msg);
    }

    protected String createFailureMessage(String task, String info) {
        ManagementMessageHelper.Message msg = new ManagementMessageHelper.Message();
        msg.setComponent(this.context.getComponentName());
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setMessage(info);
        return ManagementMessageHelper.createComponentMessage(msg);
    }
}

