/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementMessageHelper {
    private static final Log logger = LogFactory.getLog((Class)ManagementMessageHelper.class);

    public static String createComponentMessage(Message msg) {
        try {
            StringWriter sw = new StringWriter();
            XMLStreamWriter xsw = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            xsw.writeStartDocument();
            xsw.writeCharacters("\n");
            xsw.writeStartElement("component-task-result");
            xsw.writeDefaultNamespace("http://java.sun.com/xml/ns/jbi/management-message");
            xsw.writeCharacters("\n\t");
            xsw.writeStartElement("component-name");
            xsw.writeCharacters(msg.getComponent());
            xsw.writeEndElement();
            xsw.writeCharacters("\n\t");
            xsw.writeStartElement("component-task-result-details");
            xsw.writeCharacters("\n\t\t");
            xsw.writeStartElement("task-result-details");
            xsw.writeCharacters("\n\t\t\t");
            xsw.writeStartElement("task-id");
            xsw.writeCharacters(msg.getTask());
            xsw.writeEndElement();
            xsw.writeCharacters("\n\t\t\t");
            xsw.writeStartElement("task-result");
            xsw.writeCharacters(msg.getResult());
            xsw.writeEndElement();
            if (msg.getType() != null) {
                xsw.writeCharacters("\n\t\t\t");
                xsw.writeStartElement("message-type");
                xsw.writeCharacters(msg.getType());
                xsw.writeEndElement();
            }
            if (msg.getMessage() != null) {
                xsw.writeCharacters("\n\t\t\t");
                xsw.writeStartElement("task-status-message");
                xsw.writeStartElement("msg-loc-info");
                xsw.writeEmptyElement("loc-token");
                xsw.writeStartElement("loc-message");
                xsw.writeCharacters(msg.getMessage());
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            if (msg.getException() != null) {
                xsw.writeCharacters("\n\t\t\t");
                xsw.writeStartElement("exception-info");
                xsw.writeCharacters("\n\t\t\t\t");
                xsw.writeStartElement("nesting-level");
                xsw.writeCharacters("1");
                xsw.writeEndElement();
                xsw.writeCharacters("\n\t\t\t\t");
                xsw.writeStartElement("msg-loc-info");
                xsw.writeCharacters("\n\t\t\t\t\t");
                xsw.writeEmptyElement("loc-token");
                xsw.writeCharacters("\n\t\t\t\t\t");
                xsw.writeStartElement("loc-message");
                xsw.writeCharacters(msg.getException().getMessage());
                xsw.writeEndElement();
                xsw.writeCharacters("\n\t\t\t\t\t");
                xsw.writeStartElement("stack-trace");
                StringWriter sw2 = new StringWriter();
                PrintWriter pw = new PrintWriter(sw2);
                msg.getException().printStackTrace(pw);
                pw.close();
                xsw.writeCData(sw2.toString());
                xsw.writeEndElement();
                xsw.writeCharacters("\n\t\t\t\t");
                xsw.writeEndElement();
                xsw.writeCharacters("\n\t\t\t");
                xsw.writeEndElement();
            }
            xsw.writeCharacters("\n\t\t");
            xsw.writeEndElement();
            xsw.writeCharacters("\n\t");
            xsw.writeEndElement();
            xsw.writeCharacters("\n");
            xsw.writeEndElement();
            xsw.close();
            return sw.toString();
        }
        catch (Exception e) {
            logger.warn((Object)"Error generating component management message", (Throwable)e);
            return null;
        }
    }

    public static class Message {
        private String task;
        private String component;
        private String result;
        private Exception exception;
        private String type;
        private String message;

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getTask() {
            return this.task;
        }

        public void setTask(String task) {
            this.task = task;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

