/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.activesoap;

import java.io.StringWriter;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.activesoap.MessageExchange;
import org.codehaus.activesoap.RestService;
import org.servicemix.components.activesoap.ASMarshaler;
import org.servicemix.components.util.OutBinding;

public class ASInOutBinding
extends OutBinding {
    private RestService service;
    private ASMarshaler marshaler = new ASMarshaler();

    public ASInOutBinding(RestService service) {
        this.service = service;
    }

    public ASMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(ASMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void process(javax.jbi.messaging.MessageExchange messageExchange, NormalizedMessage inMessage) throws MessagingException {
        try {
            XMLStreamReader in = this.marshaler.createStreamReader(inMessage);
            StringWriter buffer = new StringWriter();
            XMLStreamWriter out = this.marshaler.createStreamWriter(buffer);
            MessageExchange asExchange = this.service.createMessageExchange(in, out);
            this.marshaler.fromNMS(asExchange, inMessage);
            this.service.invoke(asExchange);
            NormalizedMessage outMessage = messageExchange.createMessage();
            this.marshaler.setContent(outMessage, buffer.toString());
            this.marshaler.toNMS(outMessage, asExchange);
            this.answer(messageExchange, outMessage);
        }
        catch (XMLStreamException e) {
            messageExchange.setError((Exception)e);
            messageExchange.setStatus(ExchangeStatus.ERROR);
        }
        catch (Exception e) {
            messageExchange.setError(e);
            messageExchange.setStatus(ExchangeStatus.ERROR);
        }
    }
}

