/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.email;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.servicemix.components.email.MimeMailMarshaler;
import org.servicemix.components.util.OutBinding;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class MimeMailSender
extends OutBinding {
    private JavaMailSender sender;
    private MimeMailMarshaler marshaler = new MimeMailMarshaler();

    public JavaMailSender getSender() {
        return this.sender;
    }

    public void setSender(JavaMailSender sender) {
        this.sender = sender;
    }

    public MimeMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(MimeMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void init() throws JBIException {
        super.init();
        if (this.sender == null) {
            throw new JBIException("You must configure the sender property");
        }
    }

    protected void process(final MessageExchange exchange, final NormalizedMessage message) throws javax.jbi.messaging.MessagingException {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                MimeMailSender.this.marshaler.prepareMessage(mimeMessage, exchange, message);
            }
        };
        try {
            this.sender.send(preparator);
        }
        catch (MailException e) {
            throw new javax.jbi.messaging.MessagingException((Throwable)e);
        }
        this.done(exchange);
    }
}

