/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.http;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.servicemix.components.http.HttpBinding;
import org.servicemix.components.http.HttpInOutBinding;

public class BindingServlet
extends HttpServlet {
    private HttpBinding binding;

    public HttpBinding getBinding() {
        return this.binding;
    }

    public void setBinding(HttpBinding binding) {
        this.binding = binding;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.binding == null) {
            this.binding = (HttpBinding)this.getServletContext().getAttribute("binding");
            if (this.binding == null) {
                this.binding = this.createHttpBinding(config);
            }
            if (this.binding == null) {
                throw new ServletException("No binding property available on the servlet context");
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getBinding().process(request, response);
        }
        catch (JBIException e) {
            throw new ServletException("Failed to process JBI request: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getBinding().process(request, response);
        }
        catch (JBIException e) {
            throw new ServletException("Failed to process JBI request: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected HttpBinding createHttpBinding(ServletConfig config) throws ServletException {
        return new HttpInOutBinding();
    }
}

