/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.servicemix.components.util.MarshalerSupport;
import org.servicemix.jbi.jaxp.StringSource;

public class HttpMarshaler
extends MarshalerSupport {
    protected static final Source EMPTY_CONTENT = new StringSource("<payload/>");
    private String contentType = "text/xml";

    public void toNMS(MessageExchange exchange, NormalizedMessage inMessage, HttpServletRequest request) throws IOException, MessagingException {
        this.addNmsProperties(exchange, request);
        String method = request.getMethod();
        if (method != null && method.equalsIgnoreCase("POST")) {
            inMessage.setContent((Source)new StreamSource((InputStream)request.getInputStream()));
        } else {
            inMessage.setContent(EMPTY_CONTENT);
        }
    }

    public void toResponse(InOut exchange, NormalizedMessage message, HttpServletResponse response) throws IOException, TransformerException {
        if (message != null) {
            this.addHttpHeaders(response, message);
        }
        response.setContentType(this.contentType);
        this.getTransformer().toResult(message.getContent(), (Result)new StreamResult((OutputStream)response.getOutputStream()));
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void addNmsProperties(MessageExchange exchange, HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            exchange.setProperty(name, (Object)value);
        }
    }

    protected void addHttpHeaders(HttpServletResponse response, NormalizedMessage normalizedMessage) {
        Iterator iter = normalizedMessage.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Object value;
            String name = (String)iter.next();
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            response.setHeader(name, value.toString());
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String && !"Content-Length".equals(name) && !"Content-Type".equals(name);
    }
}

