/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jabber;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.servicemix.components.jabber.JabberComponentSupport;

public class JabberGroupChatSender
extends JabberComponentSupport {
    private GroupChat chat;
    private String room;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.chat == null && this.room == null) {
            throw new IllegalArgumentException("You must specify the room property");
        }
    }

    public void start() throws JBIException {
        super.start();
        if (this.chat == null) {
            this.chat = this.getConnection().createGroupChat(this.room);
        }
    }

    public void stop() throws JBIException {
        if (this.chat != null) {
            this.chat.leave();
            this.chat = null;
        }
        super.stop();
    }

    public GroupChat getChat() {
        return this.chat;
    }

    public void setChat(GroupChat chat) {
        this.chat = chat;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    protected void process(MessageExchange messageExchange, NormalizedMessage normalizedMessage) throws MessagingException {
        try {
            Message message = this.chat.createMessage();
            this.getMarshaler().fromNMS(message, normalizedMessage);
            this.chat.sendMessage(message);
            this.done(messageExchange);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (XMPPException e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

