/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jms;

import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.servicemix.jbi.jaxp.SourceMarshaler;

public class JmsMarshaler {
    private SourceMarshaler sourceMarshaler;

    public JmsMarshaler() {
        this(new SourceMarshaler());
    }

    public JmsMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public void toNMS(NormalizedMessage normalizedMessage, Message message) throws JMSException, MessagingException {
        this.addNmsProperties(normalizedMessage, message);
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            Source source = this.sourceMarshaler.asSource(textMessage.getText());
            normalizedMessage.setContent(source);
        }
        normalizedMessage.setProperty("org.servicemix.jms.message", (Object)message);
    }

    public Message createMessage(NormalizedMessage normalizedMessage, Session session) throws JMSException, TransformerException {
        String xml = this.messageAsString(normalizedMessage);
        TextMessage message = session.createTextMessage(xml);
        this.addJmsProperties((Message)message, normalizedMessage);
        return message;
    }

    public SourceMarshaler getSourceMarshaller() {
        return this.sourceMarshaler;
    }

    public void setSourceMarshaller(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    protected String messageAsString(NormalizedMessage normalizedMessage) throws TransformerException {
        return this.sourceMarshaler.asString(normalizedMessage.getContent());
    }

    protected void addJmsProperties(Message message, NormalizedMessage normalizedMessage) throws JMSException {
        Iterator iter = normalizedMessage.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Object value;
            String name = (String)iter.next();
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            message.setObjectProperty(name, value);
        }
    }

    protected void addNmsProperties(NormalizedMessage message, Message jmsMessage) throws JMSException {
        Enumeration enumeration = jmsMessage.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = jmsMessage.getObjectProperty(name);
            message.setProperty(name, value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String || value instanceof Number || value instanceof Date;
    }
}

