/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.quartz;

import java.util.Iterator;
import java.util.Map;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.servicemix.components.quartz.QuartzMarshaler;
import org.servicemix.components.util.MarshalerSupport;
import org.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultQuartzMarshaler
extends MarshalerSupport
implements QuartzMarshaler {
    public static final String CONTEXT_KEY = "org.servicemix.quartz.context";
    public static final String DETAIL_KEY = "org.servicemix.quartz.detail";

    public void populateNormalizedMessage(NormalizedMessage message, JobExecutionContext context) throws JobExecutionException, MessagingException {
        message.setProperty(CONTEXT_KEY, (Object)context);
        JobDetail detail = context.getJobDetail();
        message.setProperty(DETAIL_KEY, (Object)detail);
        JobDataMap dataMap = detail.getJobDataMap();
        Iterator iter = dataMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            message.setProperty(key, value);
        }
        try {
            Document document = this.getTransformer().createDocument();
            Element root = document.createElement("timer");
            document.appendChild(root);
            DOMUtil.addChildElement((Element)root, (String)"name", (Object)detail.getName());
            DOMUtil.addChildElement((Element)root, (String)"group", (Object)detail.getGroup());
            DOMUtil.addChildElement((Element)root, (String)"fullname", (Object)detail.getFullName());
            DOMUtil.addChildElement((Element)root, (String)"description", (Object)detail.getDescription());
            DOMUtil.addChildElement((Element)root, (String)"fireTime", (Object)context.getFireTime());
            message.setContent((Source)new DOMSource(document));
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("Failed to create content: " + e, (Throwable)e);
        }
    }
}

