/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.components.util.ComponentSupport;
import org.servicemix.jbi.RuntimeJBIException;

public class ProxyInOnlyBinding
extends ComponentSupport
implements InvocationHandler {
    private static final Log log = LogFactory.getLog((Class)ProxyInOnlyBinding.class);
    private ClassLoader cl;
    private Class[] interfaces;

    public void setTarget(Object target) {
        this.setTargetType(target.getClass().getClassLoader(), target.getClass().getInterfaces());
    }

    private void setTargetType(ClassLoader classLoader, Class[] interfaces) {
        this.cl = classLoader;
        this.interfaces = interfaces;
    }

    public Object createProxy() {
        return Proxy.newProxyInstance(this.cl, this.interfaces, (InvocationHandler)this);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invoked: " + method));
        }
        try {
            InOnly messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
            NormalizedMessage inMessage = messageExchange.createMessage();
            if (proxy != null) {
                inMessage.setProperty("proxy", proxy);
            }
            inMessage.setProperty("method", (Object)method);
            if (args != null) {
                inMessage.setProperty("args", (Object)args);
            }
            messageExchange.setInMessage(inMessage);
            this.getDeliveryChannel().send((MessageExchange)messageExchange);
            return null;
        }
        catch (JBIException e) {
            throw new RuntimeJBIException(e);
        }
    }
}

