/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.components.util.ComponentSupport;
import org.servicemix.jbi.RuntimeJBIException;

public class ProxyInOutBinding
extends ComponentSupport
implements InvocationHandler {
    private static final Log log = LogFactory.getLog((Class)ProxyInOutBinding.class);
    private ClassLoader cl;
    private final Class[] interfaces;

    public ProxyInOutBinding(Object target) {
        this(target.getClass().getClassLoader(), target.getClass().getInterfaces());
    }

    public ProxyInOutBinding(ClassLoader cl, Class[] interfaces) {
        this.cl = cl;
        this.interfaces = interfaces;
    }

    public Object createProxy() {
        return Proxy.newProxyInstance(this.cl, this.interfaces, (InvocationHandler)this);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invoked: " + proxy));
        }
        try {
            InOut messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOutExchange();
            NormalizedMessage inMessage = messageExchange.createMessage();
            inMessage.setProperty("proxy", proxy);
            inMessage.setProperty("method", (Object)method);
            inMessage.setProperty("args", (Object)args);
            messageExchange.setInMessage(inMessage);
            if (this.getDeliveryChannel().sendSync((MessageExchange)messageExchange)) {
                NormalizedMessage outMessage = messageExchange.getOutMessage();
                return this.getBody(outMessage);
            }
            if (messageExchange.getStatus() == ExchangeStatus.ERROR) {
                throw messageExchange.getError();
            }
            return null;
        }
        catch (JBIException e) {
            throw new RuntimeJBIException(e);
        }
    }
}

