/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.vfs;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemManager;
import org.servicemix.components.util.DefaultFileMarshaler;
import org.servicemix.components.util.FileMarshaler;
import org.servicemix.components.util.PollingComponentSupport;
import org.servicemix.components.vfs.FileObjectEditor;

public class FilePoller
extends PollingComponentSupport {
    private static final Log log = LogFactory.getLog((Class)FilePoller.class);
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private FileObjectEditor editor = new FileObjectEditor();
    private FileObject directory;
    private FileSelector selector;
    private Set workingSet = new CopyOnWriteArraySet();
    private boolean deleteFile = true;

    public void poll() throws Exception {
        FileObject[] files = null;
        files = this.selector != null ? this.directory.findFiles(this.selector) : this.directory.getChildren();
        for (int i = 0; i < files.length; ++i) {
            final FileObject file = files[i];
            if (this.workingSet.contains(file)) continue;
            this.workingSet.add(file);
            this.getWorkManager().scheduleWork(new Work(){

                public void run() {
                    FilePoller.this.processFileAndDelete(file);
                }

                public void release() {
                }
            });
        }
    }

    public FileObject getDirectory() {
        return this.directory;
    }

    public void setDirectory(FileObject directory) {
        this.directory = directory;
    }

    public FileSelector getSelector() {
        return this.selector;
    }

    public void setSelector(FileSelector selector) {
        this.selector = selector;
    }

    public String getPath() {
        return this.editor.getPath();
    }

    public void setPath(String path) {
        this.editor.setPath(path);
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public FileSystemManager getFileSystemManager() {
        return this.editor.getFileSystemManager();
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.editor.setFileSystemManager(fileSystemManager);
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public Set getWorkingSet() {
        return this.workingSet;
    }

    protected void init() throws JBIException {
        if (this.directory == null) {
            this.directory = this.editor.getFileObject();
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFileAndDelete(FileObject file) {
        try {
            this.processFile(file);
            if (this.isDeleteFile() && !file.delete()) {
                throw new IOException("Could not delete file " + file);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process file: " + file + ". Reason: " + e), (Throwable)e);
        }
        finally {
            this.workingSet.remove(file);
        }
    }

    protected void processFile(FileObject file) throws Exception {
        String name = file.getName().getURI();
        InputStream in = file.getContent().getInputStream();
        if (in == null) {
            throw new JBIException("No input available for file!");
        }
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, in, name);
        this.getDeliveryChannel().sendSync((MessageExchange)exchange);
        in.close();
    }
}

