/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.vfs;

import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.servicemix.components.util.DefaultFileMarshaler;
import org.servicemix.components.util.FileMarshaler;
import org.servicemix.components.util.OutBinding;
import org.servicemix.components.vfs.FileObjectEditor;

public class FileWriter
extends OutBinding {
    private static final Log log = LogFactory.getLog((Class)FileWriter.class);
    private FileObject directory;
    private FileObjectEditor editor = new FileObjectEditor();
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String uniqueFileName = "ServiceMix";

    public FileObject getDirectory() {
        return this.directory;
    }

    public void setDirectory(FileObject directory) {
        this.directory = directory;
    }

    public String getPath() {
        return this.editor.getPath();
    }

    public void setPath(String path) {
        this.editor.setPath(path);
    }

    public FileSystemManager getFileSystemManager() {
        return this.editor.getFileSystemManager();
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.editor.setFileSystemManager(fileSystemManager);
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getUniqueFileName() {
        return this.uniqueFileName;
    }

    public void setUniqueFileName(String uniqueFileName) {
        this.uniqueFileName = uniqueFileName;
    }

    protected void init() throws JBIException {
        if (this.directory == null) {
            this.directory = this.editor.getFileObject();
        }
        super.init();
    }

    protected void process(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        OutputStream out = null;
        try {
            String name = this.marshaler.getOutputName(exchange, message);
            if (name == null) {
                throw new MessagingException("No output name available. Cannot output message!");
            }
            FileObject newFile = this.directory.resolveFile(name);
            FileContent content = newFile.getContent();
            if (content != null) {
                out = content.getOutputStream();
            }
            if (out == null) {
                throw new MessagingException("No output stream available for output name: " + name);
            }
            this.marshaler.writeMessage(exchange, message, out, name);
            this.done(exchange);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }
}

