/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.xfire;

import java.io.ByteArrayOutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.servicemix.components.util.OutBinding;
import org.servicemix.components.xfire.XMarshaler;

public class XFireBinding
extends OutBinding {
    private XMarshaler marshaler = new XMarshaler();
    private XFire xfire;

    protected void process(MessageExchange messageExchange, NormalizedMessage nm) throws MessagingException {
        try {
            XMLStreamReader reader = this.marshaler.createStreamReader(nm);
            if (reader == null) {
                this.fail(messageExchange, (Exception)((Object)new JBIException("Could not get source as XMLStreamReader.")));
                return;
            }
            InMessage in = new InMessage(reader, "");
            MessageContext context = new MessageContext();
            context.setXFire(this.xfire);
            context.setService(this.xfire.getServiceRegistry().getService(this.getService().getLocalPart()));
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            context.setProperty("urn:xfire:channel:backchannel", (Object)buffer);
            Transport transport = this.xfire.getTransportManager().getTransport("urn:xfire:transport:local");
            Channel channel = transport.createChannel();
            channel.receive(context, in);
            NormalizedMessage outMessage = messageExchange.createMessage();
            this.marshaler.setContent(outMessage, buffer.toString());
            this.marshaler.toNMS(outMessage, context.getOutMessage());
            this.answer(messageExchange, outMessage);
        }
        catch (Exception e) {
            this.fail(messageExchange, e);
        }
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }
}

