/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.xsql;

import java.net.URL;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLRequest;
import org.servicemix.MessageExchangeListener;
import org.servicemix.components.util.TransformComponentSupport;
import org.servicemix.jbi.jaxp.SourceTransformer;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

public class XSQLComponent
extends TransformComponentSupport
implements MessageExchangeListener {
    private XSQLConnectionManagerFactory connectionManagerFactory;
    private URL baseURL;
    private XMLDocument xsql;
    private Resource xsqlResource;
    private SourceTransformer sourceTransformer = new SourceTransformer();

    protected void init() throws JBIException {
        super.init();
        if (this.xsql == null && this.xsqlResource != null) {
            try {
                DOMParser parser = new DOMParser();
                parser.parse(this.xsqlResource.getInputStream());
                this.xsql = parser.getDocument();
            }
            catch (Exception e) {
                throw new JBIException("Failed to parse: " + this.xsqlResource + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    public XSQLConnectionManagerFactory getConnectionManagerFactory() {
        return this.connectionManagerFactory;
    }

    public void setConnectionManagerFactory(XSQLConnectionManagerFactory connectionManagerFactory) {
        this.connectionManagerFactory = connectionManagerFactory;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public XMLDocument getXsql() {
        return this.xsql;
    }

    public void setXsql(XMLDocument xsql) {
        this.xsql = xsql;
    }

    public Resource getXsqlResource() {
        return this.xsqlResource;
    }

    public void setXsqlResource(Resource xsqlResource) {
        this.xsqlResource = xsqlResource;
    }

    public SourceTransformer getSourceTransformer() {
        return this.sourceTransformer;
    }

    public void setSourceTransformer(SourceTransformer sourceTransformer) {
        this.sourceTransformer = sourceTransformer;
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        XMLDocument document = this.createXSQLDocument(exchange, in);
        XSQLRequest request = this.createXSQLRequest(exchange, in, document);
        Document response = request.processToXML();
        out.setContent((Source)new DOMSource(response));
        return true;
    }

    protected XSQLRequest createXSQLRequest(MessageExchange exchange, NormalizedMessage in, XMLDocument document) {
        return new XSQLRequest(this.connectionManagerFactory, document, this.baseURL);
    }

    protected XMLDocument createXSQLDocument(MessageExchange exchange, NormalizedMessage in) throws MessagingException {
        if (this.xsql != null) {
            return this.xsql;
        }
        try {
            DocumentBuilder builder = new DocumentBuilder();
            SAXResult result = new SAXResult((ContentHandler)builder);
            this.sourceTransformer.toResult(in.getContent(), (Result)result);
            return builder.getDocument();
        }
        catch (TransformerException e) {
            throw new MessagingException("Failed to convert inbound message content to an XMLDocument. Reason: " + e, (Throwable)e);
        }
    }
}

