/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.classman.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.spice.classman.builder.LoaderResolver;
import org.codehaus.spice.classman.metadata.ClassLoaderMetaData;
import org.codehaus.spice.classman.metadata.ClassLoaderSetMetaData;
import org.codehaus.spice.classman.metadata.FileSetMetaData;
import org.codehaus.spice.classman.metadata.JoinMetaData;
import org.codehaus.spice.extension.Extension;

public class LoaderBuilder {
    public Map buildClassLoaders(ClassLoaderSetMetaData metadata, LoaderResolver resolver, Map predefined) throws Exception {
        HashMap classLoaders = new HashMap();
        this.addPredefined(metadata.getPredefined(), predefined, classLoaders);
        this.addAllClassLoaders(metadata, resolver, classLoaders);
        this.addAllJoins(metadata, resolver, classLoaders);
        return classLoaders;
    }

    private void addAllClassLoaders(ClassLoaderSetMetaData metaData, LoaderResolver resolver, Map classLoaders) throws Exception {
        ClassLoaderMetaData[] classLoaderDefs = metaData.getClassLoaders();
        int i = 0;
        while (i < classLoaderDefs.length) {
            String name = classLoaderDefs[i].getName();
            this.processClassLoader(name, metaData, resolver, classLoaders);
            ++i;
        }
    }

    private void addAllJoins(ClassLoaderSetMetaData metaData, LoaderResolver resolver, Map classLoaders) throws Exception {
        JoinMetaData[] joins = metaData.getJoins();
        int i = 0;
        while (i < joins.length) {
            String name = joins[i].getName();
            this.processClassLoader(name, metaData, resolver, classLoaders);
            ++i;
        }
    }

    private void processClassLoader(String name, ClassLoaderSetMetaData set, LoaderResolver resolver, Map classLoaders) throws Exception {
        if (classLoaders.containsKey(name)) {
            return;
        }
        ClassLoaderMetaData regular = set.getClassLoader(name);
        if (null != regular) {
            this.processClassLoader(regular.getParent(), set, resolver, classLoaders);
            ClassLoader classLoader = this.buildRegularClassLoader(regular, resolver, classLoaders);
            classLoaders.put(name, classLoader);
        } else {
            JoinMetaData join = set.getJoin(name);
            if (null == join) {
                String message = "Unknown classloader " + name;
                throw new Exception(message);
            }
            String[] names = join.getClassloaders();
            int i = 0;
            while (i < names.length) {
                this.processClassLoader(names[i], set, resolver, classLoaders);
                ++i;
            }
            ClassLoader classLoader = this.buildJoinClassLoader(join, resolver, classLoaders);
            classLoaders.put(name, classLoader);
        }
    }

    private ClassLoader buildJoinClassLoader(JoinMetaData join, LoaderResolver resolver, Map classLoaders) throws Exception {
        ArrayList list = new ArrayList();
        String[] names = join.getClassloaders();
        int i = 0;
        while (i < names.length) {
            list.add(classLoaders.get(names[i]));
            ++i;
        }
        ClassLoader[] elements = list.toArray(new ClassLoader[list.size()]);
        return resolver.createJoinClassLoader(elements);
    }

    private ClassLoader buildRegularClassLoader(ClassLoaderMetaData metaData, LoaderResolver resolver, Map classLoaders) throws Exception {
        ClassLoader parent = (ClassLoader)classLoaders.get(metaData.getParent());
        ArrayList<URL> urlSet = new ArrayList<URL>();
        String[] entrys = metaData.getEntrys();
        int i = 0;
        while (i < entrys.length) {
            URL url = resolver.resolveURL(entrys[i]);
            urlSet.add(url);
            ++i;
        }
        FileSetMetaData[] filesets = metaData.getFilesets();
        int i2 = 0;
        while (i2 < filesets.length) {
            FileSetMetaData fileset = filesets[i2];
            String baseDirectory = fileset.getBaseDirectory();
            String[] includes = fileset.getIncludes();
            String[] excludes = fileset.getExcludes();
            URL[] urls = resolver.resolveFileSet(baseDirectory, includes, excludes);
            int j = 0;
            while (j < urls.length) {
                urlSet.add(urls[j]);
                ++j;
            }
            ++i2;
        }
        Extension[] extensions = metaData.getExtensions();
        int i3 = 0;
        while (i3 < extensions.length) {
            URL url = resolver.resolveExtension(extensions[i3]);
            urlSet.add(url);
            ++i3;
        }
        URL[] urls = urlSet.toArray(new URL[urlSet.size()]);
        return resolver.createClassLoader(parent, urls);
    }

    private void addPredefined(String[] entrys, Map predefined, HashMap classLoaders) {
        int i = 0;
        while (i < entrys.length) {
            String name = entrys[i];
            ClassLoader classLoader = (ClassLoader)predefined.get(name);
            if (null == classLoader) {
                String message = "Missing predefined ClassLoader " + name;
                throw new IllegalArgumentException(message);
            }
            classLoaders.put(name, classLoader);
            ++i;
        }
    }
}

