/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.classman.builder;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Manifest;
import org.codehaus.spice.classman.builder.LoaderResolver;
import org.codehaus.spice.classman.runtime.JoinClassLoader;
import org.codehaus.spice.extension.Extension;
import org.codehaus.spice.salt.i18n.ResourceManager;
import org.codehaus.spice.salt.i18n.Resources;
import org.codehaus.spice.salt.io.FileUtil;
import org.codehaus.spice.salt.io.PathMatcher;

public class SimpleLoaderResolver
implements LoaderResolver {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$codehaus$spice$classman$builder$SimpleLoaderResolver == null ? (class$org$codehaus$spice$classman$builder$SimpleLoaderResolver = SimpleLoaderResolver.class$("org.codehaus.spice.classman.builder.SimpleLoaderResolver")) : class$org$codehaus$spice$classman$builder$SimpleLoaderResolver));
    private File m_baseDirectory;
    static /* synthetic */ Class class$org$codehaus$spice$classman$builder$SimpleLoaderResolver;

    public SimpleLoaderResolver(File baseDirectory) {
        this.setBaseDirectory(baseDirectory);
    }

    public URL resolveExtension(Extension extension) throws Exception {
        throw new UnsupportedOperationException();
    }

    public URL resolveURL(String location) throws Exception {
        File file = this.getFileFor(location);
        String url = file.toURL().toString();
        if (file.isDirectory()) {
            url = url + "/";
        }
        return new URL(url);
    }

    public URL[] resolveFileSet(String baseDirectory, String[] includes, String[] excludes) throws Exception {
        File base = this.getFileFor(".");
        return this.resolveFileSet(base, baseDirectory, includes, excludes);
    }

    public ClassLoader createJoinClassLoader(ClassLoader[] classLoaders) throws Exception {
        return new JoinClassLoader(classLoaders, ClassLoader.getSystemClassLoader());
    }

    public ClassLoader createClassLoader(ClassLoader parent, URL[] urls) throws Exception {
        URL[] classpath = this.determineCompleteClasspath(urls);
        return new URLClassLoader(classpath, parent);
    }

    protected final URL[] determineCompleteClasspath(URL[] urls) throws Exception {
        ArrayList<URL> classpathSet = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            classpathSet.add(url);
            ++i;
        }
        File[] files = this.getOptionalPackagesFor(urls);
        int i2 = 0;
        while (i2 < files.length) {
            File file = files[i2];
            classpathSet.add(file.toURL());
            ++i2;
        }
        return classpathSet.toArray(new URL[classpathSet.size()]);
    }

    protected File getFileFor(String location) throws IOException {
        File base = this.getBaseDirectory();
        if (null == base) {
            base = new File(".");
        }
        return new File(base, location).getCanonicalFile();
    }

    protected File getBaseDirectory() {
        return this.m_baseDirectory;
    }

    protected void setBaseDirectory(File baseDirectory) {
        this.m_baseDirectory = baseDirectory;
    }

    protected final File[] getOptionalPackagesFor(URL[] classPath) throws Exception {
        Manifest[] manifests = this.getManifests(classPath);
        Extension[] available = Extension.getAvailable((Manifest[])manifests);
        Extension[] required = Extension.getRequired((Manifest[])manifests);
        if (this.isDebugEnabled()) {
            String message1 = REZ.format("available-extensions", Arrays.asList(available));
            this.debug(message1);
            String message2 = REZ.format("required-extensions", Arrays.asList(required));
            this.debug(message2);
        }
        if (0 == required.length) {
            return new File[0];
        }
        HashSet dependencies = new HashSet();
        HashSet unsatisfied = new HashSet();
        this.scanDependencies(required, available, dependencies, unsatisfied);
        int size = unsatisfied.size();
        if (0 != size) {
            Iterator iterator = unsatisfied.iterator();
            while (iterator.hasNext()) {
                Extension extension = (Extension)iterator.next();
                Object[] params = new Object[]{extension.getExtensionName(), extension.getSpecificationVendor(), extension.getSpecificationVersion(), extension.getImplementationVendor(), extension.getImplementationVendorID(), extension.getImplementationVersion(), extension.getImplementationURL()};
                String message = REZ.format("missing.extension", params);
                this.warn(message);
            }
            String message = REZ.format("unsatisfied.extensions", (Object)new Integer(size));
            throw new Exception(message);
        }
        if (this.isDebugEnabled()) {
            String message = REZ.format("optional-packages-added", dependencies);
            this.debug(message);
        }
        return dependencies.toArray(new File[dependencies.size()]);
    }

    protected void scanDependencies(Extension[] required, Extension[] available, Set dependencies, Set unsatisfied) {
        throw new UnsupportedOperationException();
    }

    protected void warn(String message) {
    }

    protected boolean isDebugEnabled() {
        return false;
    }

    protected void debug(String message) {
    }

    private Manifest[] getManifests(URL[] classPath) throws Exception {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        int i = 0;
        while (i < classPath.length) {
            URL element = classPath[i];
            if (element.getFile().endsWith(".jar")) {
                try {
                    URL url = new URL("jar:" + element + "!/");
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    Manifest manifest = connection.getManifest();
                    if (null != manifest) {
                        manifests.add(manifest);
                    }
                }
                catch (IOException ioe) {
                    String message = REZ.format("bad-classpath-entry", (Object)element);
                    throw new Exception(message);
                }
            }
            ++i;
        }
        return manifests.toArray(new Manifest[0]);
    }

    protected final URL[] resolveFileSet(File base, String baseDirectory, String[] includes, String[] excludes) {
        String newBaseDirectory = FileUtil.normalize((String)baseDirectory);
        String[] newIncludes = this.prefixPatterns(newBaseDirectory, includes);
        String[] newExcludes = this.prefixPatterns(newBaseDirectory, excludes);
        PathMatcher matcher = new PathMatcher(newIncludes, newExcludes);
        File[] files = FileUtil.resolveFileSet((File)base, (PathMatcher)matcher);
        try {
            return FileUtil.toURLs((File[])files);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }

    private String[] prefixPatterns(String prefix, String[] patterns) {
        if (0 == prefix.length() || ".".equals(prefix)) {
            return patterns;
        }
        String[] newPatterns = new String[patterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            newPatterns[i] = prefix + "/" + patterns[i];
            ++i;
        }
        return newPatterns;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

