/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.classman.metadata;

import org.codehaus.spice.classman.metadata.ClassLoaderMetaData;
import org.codehaus.spice.classman.metadata.JoinMetaData;

public class ClassLoaderSetMetaData {
    private final String m_default;
    private final String[] m_predefined;
    private final ClassLoaderMetaData[] m_classLoaders;
    private final JoinMetaData[] m_joins;

    public ClassLoaderSetMetaData(String aDefault, String[] predefined, ClassLoaderMetaData[] classLoaders, JoinMetaData[] joins) {
        if (null == aDefault) {
            throw new NullPointerException("aDefault");
        }
        if (null == classLoaders) {
            throw new NullPointerException("classLoaders");
        }
        if (null == joins) {
            throw new NullPointerException("joins");
        }
        if (null == predefined) {
            throw new NullPointerException("predefined");
        }
        this.m_default = aDefault;
        this.m_predefined = predefined;
        this.m_classLoaders = classLoaders;
        this.m_joins = joins;
    }

    public String getDefault() {
        return this.m_default;
    }

    public String[] getPredefined() {
        return this.m_predefined;
    }

    public ClassLoaderMetaData[] getClassLoaders() {
        return this.m_classLoaders;
    }

    public JoinMetaData[] getJoins() {
        return this.m_joins;
    }

    public boolean isPredefined(String name) {
        int i = 0;
        while (i < this.m_predefined.length) {
            if (this.m_predefined[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ClassLoaderMetaData getClassLoader(String name) {
        int i = 0;
        while (i < this.m_classLoaders.length) {
            ClassLoaderMetaData classLoader = this.m_classLoaders[i];
            if (classLoader.getName().equals(name)) {
                return classLoader;
            }
            ++i;
        }
        return null;
    }

    public JoinMetaData getJoin(String name) {
        int i = 0;
        while (i < this.m_joins.length) {
            JoinMetaData join = this.m_joins[i];
            if (join.getName().equals(name)) {
                return join;
            }
            ++i;
        }
        return null;
    }
}

