/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.classman.reader;

import java.util.ArrayList;
import org.codehaus.spice.classman.metadata.ClassLoaderMetaData;
import org.codehaus.spice.classman.metadata.ClassLoaderSetMetaData;
import org.codehaus.spice.classman.metadata.FileSetMetaData;
import org.codehaus.spice.classman.metadata.JoinMetaData;
import org.codehaus.spice.extension.Extension;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ClassLoaderSetReader {
    public ClassLoaderSetMetaData build(Element config) throws Exception {
        String defaultClassLoader = config.getAttribute("default");
        if (this.isUnspecified(defaultClassLoader)) {
            String message = "Default classloader not specified.";
            throw new Exception("Default classloader not specified.");
        }
        String version = config.getAttribute("version");
        if (!"1.0".equals(version)) {
            String message = "Bad version:" + version;
            throw new Exception(message);
        }
        NodeList joinConfigs = config.getElementsByTagName("join");
        JoinMetaData[] joins = this.buildJoins(joinConfigs);
        NodeList clConfigs = config.getElementsByTagName("classloader");
        ClassLoaderMetaData[] classloaders = this.buildClassLoaders(clConfigs);
        NodeList predefinedConfigs = config.getElementsByTagName("predefined");
        String[] predefined = this.buildPredefined(predefinedConfigs);
        return new ClassLoaderSetMetaData(defaultClassLoader, predefined, classloaders, joins);
    }

    private String[] buildPredefined(NodeList configs) {
        ArrayList<String> predefines = new ArrayList<String>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)configs.item(i);
            String predefined = element.getAttribute("name");
            predefines.add(predefined);
            ++i;
        }
        return predefines.toArray(new String[predefines.size()]);
    }

    private ClassLoaderMetaData[] buildClassLoaders(NodeList configs) throws Exception {
        ArrayList<ClassLoaderMetaData> loaders = new ArrayList<ClassLoaderMetaData>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Element item = (Element)configs.item(i);
            ClassLoaderMetaData loader = this.buildLoader(item);
            loaders.add(loader);
            ++i;
        }
        return loaders.toArray(new ClassLoaderMetaData[loaders.size()]);
    }

    private ClassLoaderMetaData buildLoader(Element config) throws Exception {
        String name = config.getAttribute("name");
        String parent = config.getAttribute("parent");
        String[] entrys = this.buildEntrys(config.getElementsByTagName("entry"));
        Extension[] extensions = this.buildExtensions(config.getElementsByTagName("extension"));
        FileSetMetaData[] fileSets = this.buildFileSets(config.getElementsByTagName("fileset"));
        return new ClassLoaderMetaData(name, parent, entrys, extensions, fileSets);
    }

    private Extension[] buildExtensions(NodeList configs) throws Exception {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Extension extension = this.buildExtension((Element)configs.item(i));
            extensions.add(extension);
            ++i;
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    private Extension buildExtension(Element config) throws Exception {
        String name = config.getAttribute("name");
        if (this.isUnspecified(name)) {
            String message = "Missing name from extension";
            throw new Exception("Missing name from extension");
        }
        String specVersion = config.getAttribute("specification-version");
        String specVendor = config.getAttribute("specification-vendor");
        String implVersion = config.getAttribute("implementation-version");
        String implVendor = config.getAttribute("implementation-vendor");
        String implVendorID = config.getAttribute("implementation-vendor-id");
        String implURL = config.getAttribute("implementation-url");
        return new Extension(name, specVersion, specVendor, implVersion, implVendor, implVendorID, implURL);
    }

    private FileSetMetaData[] buildFileSets(NodeList configs) {
        ArrayList<FileSetMetaData> fileSets = new ArrayList<FileSetMetaData>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            FileSetMetaData fileSet = this.buildFileSet((Element)configs.item(i));
            fileSets.add(fileSet);
            ++i;
        }
        return fileSets.toArray(new FileSetMetaData[fileSets.size()]);
    }

    private FileSetMetaData buildFileSet(Element config) {
        String dir = config.getAttribute("dir");
        String[] includes = this.buildSelectors(config.getElementsByTagName("include"));
        String[] excludes = this.buildSelectors(config.getElementsByTagName("exclude"));
        return new FileSetMetaData(dir, includes, excludes);
    }

    private String[] buildSelectors(NodeList configs) {
        ArrayList<String> selectors = new ArrayList<String>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)configs.item(i);
            String name = element.getAttribute("name");
            selectors.add(name);
            ++i;
        }
        return selectors.toArray(new String[selectors.size()]);
    }

    private String[] buildEntrys(NodeList configs) {
        ArrayList<String> entrys = new ArrayList<String>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Element config = (Element)configs.item(i);
            String entry = config.getAttribute("location");
            entrys.add(entry);
            ++i;
        }
        return entrys.toArray(new String[entrys.size()]);
    }

    private JoinMetaData[] buildJoins(NodeList configs) {
        ArrayList<JoinMetaData> joins = new ArrayList<JoinMetaData>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Element config = (Element)configs.item(i);
            JoinMetaData join = this.buildJoin(config);
            joins.add(join);
            ++i;
        }
        return joins.toArray(new JoinMetaData[joins.size()]);
    }

    private JoinMetaData buildJoin(Element config) {
        String name = config.getAttribute("name");
        NodeList children = config.getElementsByTagName("classloader-ref");
        String[] classloaders = this.buildClassLoaderRefs(children);
        return new JoinMetaData(name, classloaders);
    }

    private String[] buildClassLoaderRefs(NodeList configs) {
        ArrayList<String> refs = new ArrayList<String>();
        int length = configs.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)configs.item(i);
            String ref = element.getAttribute("name");
            refs.add(ref);
            ++i;
        }
        return refs.toArray(new String[refs.size()]);
    }

    private boolean isUnspecified(String attribute) {
        return "".equals(attribute);
    }
}

