/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.classman.verifier;

import org.codehaus.spice.classman.metadata.ClassLoaderMetaData;
import org.codehaus.spice.classman.metadata.ClassLoaderSetMetaData;
import org.codehaus.spice.classman.metadata.JoinMetaData;
import org.codehaus.spice.salt.i18n.ResourceManager;
import org.codehaus.spice.salt.i18n.Resources;

public class ClassLoaderVerifier {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$codehaus$spice$classman$verifier$ClassLoaderVerifier == null ? (class$org$codehaus$spice$classman$verifier$ClassLoaderVerifier = ClassLoaderVerifier.class$("org.codehaus.spice.classman.verifier.ClassLoaderVerifier")) : class$org$codehaus$spice$classman$verifier$ClassLoaderVerifier));
    static /* synthetic */ Class class$org$codehaus$spice$classman$verifier$ClassLoaderVerifier;

    public void verifyClassLoaderSet(ClassLoaderSetMetaData set) throws Exception {
        String message = null;
        message = REZ.getString("valid-names.notice");
        this.info(message);
        this.verifyNames(set);
        message = REZ.getString("valid-parents.notice");
        this.info(message);
        this.verifyParents(set);
        message = REZ.getString("valid-links.notice");
        this.info(message);
        this.verifyLinks(set);
        message = REZ.getString("default-loader.notice");
        this.info(message);
        this.verifyDefaultLoaderExists(set);
        message = REZ.getString("unique-classloader.notice");
        this.info(message);
        this.verifyUniqueClassLoaderNames(set);
        message = REZ.getString("unique-joins.notice");
        this.info(message);
        this.verifyUniqueJoinNames(set);
        message = REZ.getString("unique-predefined.notice");
        this.info(message);
        this.verifyUniquePredefinedNames(set);
        message = REZ.getString("unique-joins-entrys.notice");
        this.info(message);
        this.verifyUniqueJoinEntrys(set);
        message = REZ.getString("unique-classpath-entrys.notice");
        this.info(message);
        this.verifyUniqueClassLoaderEntrys(set);
    }

    protected void info(String message) {
    }

    private void verifyNames(ClassLoaderSetMetaData set) throws Exception {
        ClassLoaderMetaData[] classLoaders = set.getClassLoaders();
        int i = 0;
        while (i < classLoaders.length) {
            String name = classLoaders[i].getName();
            this.verifyName(name);
            ++i;
        }
        JoinMetaData[] joins = set.getJoins();
        int i2 = 0;
        while (i2 < joins.length) {
            String name = joins[i2].getName();
            this.verifyName(name);
            ++i2;
        }
    }

    private void verifyParents(ClassLoaderSetMetaData set) throws Exception {
        ClassLoaderMetaData[] classLoaders = set.getClassLoaders();
        int i = 0;
        while (i < classLoaders.length) {
            ClassLoaderMetaData classLoader = classLoaders[i];
            String parent = classLoader.getParent();
            if (!this.isLoaderDefined(parent, set)) {
                String message = REZ.format("invalid-parent.error", (Object)classLoader.getName(), (Object)parent);
                throw new Exception(message);
            }
            ++i;
        }
    }

    private void verifyLinks(ClassLoaderSetMetaData set) throws Exception {
        JoinMetaData[] joins = set.getJoins();
        int i = 0;
        while (i < joins.length) {
            this.verifyLinks(joins[i], set);
            ++i;
        }
    }

    private void verifyLinks(JoinMetaData join, ClassLoaderSetMetaData set) throws Exception {
        String[] classloaders = join.getClassloaders();
        int i = 0;
        while (i < classloaders.length) {
            String classloader = classloaders[i];
            if (!this.isLoaderDefined(classloader, set)) {
                String message = REZ.format("bad-join-link.error", (Object)join.getName(), (Object)classloader);
                throw new Exception(message);
            }
            ++i;
        }
    }

    private void verifyName(String name) throws Exception {
        int size = name.length();
        if (0 == size) {
            String message = REZ.format("empty-name.error", (Object)name);
            throw new Exception(message);
        }
        char ch = name.charAt(0);
        if (!Character.isLetter(ch) && '_' != ch) {
            String message = REZ.format("name-invalid-start.error", (Object)name);
            throw new Exception(message);
        }
        int i = 1;
        while (i < size) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && '_' != c && '-' != c && '.' != c) {
                String message = REZ.format("name-invalid-char.error", (Object)name, (Object)String.valueOf(c));
                throw new Exception(message);
            }
            ++i;
        }
    }

    private void verifyUniqueClassLoaderEntrys(ClassLoaderSetMetaData set) throws Exception {
        ClassLoaderMetaData[] classLoaders = set.getClassLoaders();
        int i = 0;
        while (i < classLoaders.length) {
            this.verifyUniqueClassLoaderEntrys(classLoaders[i]);
            ++i;
        }
    }

    private void verifyUniqueClassLoaderEntrys(ClassLoaderMetaData classLoader) throws Exception {
        String[] entrys = classLoader.getEntrys();
        int i = 0;
        while (i < entrys.length) {
            String location = entrys[i];
            int j = i + 1;
            while (j < entrys.length) {
                if (location.equals(entrys[j])) {
                    String message = REZ.format("classloader-dup-entrys.error", (Object)classLoader.getName(), (Object)location);
                    throw new Exception(message);
                }
                ++j;
            }
            ++i;
        }
    }

    private void verifyUniqueJoinEntrys(ClassLoaderSetMetaData set) throws Exception {
        JoinMetaData[] joins = set.getJoins();
        int i = 0;
        while (i < joins.length) {
            this.verifyUniqueJoinEntrys(joins[i]);
            ++i;
        }
    }

    private void verifyUniqueJoinEntrys(JoinMetaData join) throws Exception {
        String[] classloaders = join.getClassloaders();
        int j = 0;
        while (j < classloaders.length) {
            String name = classloaders[j];
            int k = j + 1;
            while (k < classloaders.length) {
                String other = classloaders[k];
                if (other.equals(name)) {
                    String message = REZ.format("join-dup-entrys.error", (Object)join.getName(), (Object)name);
                    throw new Exception(message);
                }
                ++k;
            }
            ++j;
        }
    }

    private void verifyUniquePredefinedNames(ClassLoaderSetMetaData set) throws Exception {
        String[] predefined = set.getPredefined();
        int i = 0;
        while (i < predefined.length) {
            String name = predefined[i];
            int j = i + 1;
            while (j < predefined.length) {
                String other = predefined[j];
                if (other.equals(name)) {
                    String message = REZ.format("duplicate-name.error", (Object)"predefined", (Object)"predefined", (Object)name);
                    throw new Exception(message);
                }
                ++j;
            }
            ++i;
        }
    }

    private void verifyUniqueClassLoaderNames(ClassLoaderSetMetaData set) throws Exception {
        ClassLoaderMetaData[] classLoaders = set.getClassLoaders();
        int i = 0;
        while (i < classLoaders.length) {
            ClassLoaderMetaData classLoader = classLoaders[i];
            this.verifyUniqueName(set, classLoader.getName(), "classloader", classLoader);
            ++i;
        }
    }

    private void verifyUniqueName(ClassLoaderSetMetaData set, String name, String type, Object entity) throws Exception {
        if (set.isPredefined(name)) {
            String message = REZ.format("duplicate-name.error", (Object)type, (Object)"predefined", (Object)name);
            throw new Exception(message);
        }
        JoinMetaData[] joins = set.getJoins();
        int j = 0;
        while (j < joins.length) {
            JoinMetaData other = joins[j];
            if (other != entity && other.getName().equals(name)) {
                String message = REZ.format("duplicate-name.error", (Object)type, (Object)"join", (Object)name);
                throw new Exception(message);
            }
            ++j;
        }
        ClassLoaderMetaData[] classLoaders = set.getClassLoaders();
        int j2 = 0;
        while (j2 < classLoaders.length) {
            ClassLoaderMetaData other = classLoaders[j2];
            if (other != entity && other.getName().equals(name)) {
                String message = REZ.format("duplicate-name.error", (Object)type, (Object)"classloader", (Object)name);
                throw new Exception(message);
            }
            ++j2;
        }
    }

    private void verifyUniqueJoinNames(ClassLoaderSetMetaData set) throws Exception {
        JoinMetaData[] joins = set.getJoins();
        int i = 0;
        while (i < joins.length) {
            JoinMetaData join = joins[i];
            this.verifyUniqueName(set, join.getName(), "join", join);
            ++i;
        }
    }

    private void verifyDefaultLoaderExists(ClassLoaderSetMetaData set) throws Exception {
        String name = set.getDefault();
        if (!this.isLoaderDefined(name, set)) {
            String message = REZ.format("missing-default-loader.error", (Object)name);
            throw new Exception(message);
        }
    }

    private boolean isLoaderDefined(String name, ClassLoaderSetMetaData set) {
        if (set.isPredefined(name)) {
            return true;
        }
        if (null != set.getClassLoader(name)) {
            return true;
        }
        return null != set.getJoin(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

