/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.metaclass;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.realityforge.metaclass.introspector.MetaClassException;
import org.realityforge.metaclass.introspector.MetaClassIntrospector;
import org.realityforge.metaclass.model.Attribute;
import org.realityforge.metaclass.model.ClassDescriptor;
import org.realityforge.metaclass.model.FieldDescriptor;
import org.realityforge.metaclass.model.MethodDescriptor;
import org.realityforge.metaclass.model.ParameterDescriptor;

public class Attributes {
    public static Attribute getAttributeByName(Attribute[] attributes, String name) {
        int i = 0;
        while (i < attributes.length) {
            Attribute attribute = attributes[i];
            if (attribute.getName().equals(name)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public static Attribute[] getAttributesByName(Attribute[] attributes, String name) {
        ArrayList<Attribute> results = new ArrayList<Attribute>();
        int i = 0;
        while (i < attributes.length) {
            Attribute attribute = attributes[i];
            String attributeName = attribute.getName();
            if (attributeName.equals(name)) {
                results.add(attribute);
            }
            ++i;
        }
        return results.toArray(new Attribute[results.size()]);
    }

    public static Attribute[] getAttributes(Class clazz) {
        try {
            ClassDescriptor descriptor = Attributes.getClassInfo(clazz);
            return descriptor.getAttributes();
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute[] getAttributes(Class clazz, String name) {
        try {
            ClassDescriptor descriptor = Attributes.getClassInfo(clazz);
            return Attributes.getAttributesByName(descriptor.getAttributes(), name);
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute getAttribute(Class clazz, String name) {
        try {
            ClassDescriptor descriptor = Attributes.getClassInfo(clazz);
            return Attributes.getAttributeByName(descriptor.getAttributes(), name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Attribute[] getAttributes(Field field) {
        try {
            return Attributes.getField(field).getAttributes();
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute[] getAttributes(Field field, String name) {
        try {
            return Attributes.getAttributesByName(Attributes.getField(field).getAttributes(), name);
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute getAttribute(Field field, String name) {
        try {
            return Attributes.getAttributeByName(Attributes.getField(field).getAttributes(), name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Attribute[] getAttributes(Method method) {
        try {
            MethodDescriptor descriptor = Attributes.getMethod(method);
            return descriptor.getAttributes();
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute[] getAttributes(Method method, String name) {
        try {
            MethodDescriptor descriptor = Attributes.getMethod(method);
            return Attributes.getAttributesByName(descriptor.getAttributes(), name);
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute getAttribute(Method method, String name) {
        try {
            MethodDescriptor descriptor = Attributes.getMethod(method);
            return Attributes.getAttributeByName(descriptor.getAttributes(), name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Attribute[] getAttributes(Constructor constructor) {
        try {
            return Attributes.getConstructor(constructor).getAttributes();
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute[] getAttributes(Constructor constructor, String name) {
        try {
            Attribute[] attributes = Attributes.getConstructor(constructor).getAttributes();
            return Attributes.getAttributesByName(attributes, name);
        }
        catch (Exception e) {
            return Attribute.EMPTY_SET;
        }
    }

    public static Attribute getAttribute(Constructor constructor, String name) {
        try {
            Attribute[] attributes = Attributes.getConstructor(constructor).getAttributes();
            return Attributes.getAttributeByName(attributes, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FieldDescriptor getField(Field field) throws MetaClassException {
        FieldDescriptor[] fields = Attributes.getClassInfo(field.getDeclaringClass()).getFields();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor candidate = fields[i];
            if (candidate.getName().equals(field.getName())) {
                return candidate;
            }
            ++i;
        }
        throw new MetaClassException("No FieldDescriptor matching " + field);
    }

    public static MethodDescriptor getMethod(Method method) throws MetaClassException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        MethodDescriptor[] methods = Attributes.getClassInfo(method.getDeclaringClass()).getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodDescriptor candidate = methods[i];
            ParameterDescriptor[] parameters = candidate.getParameters();
            if (candidate.getName().equals(method.getName()) && parameters.length == parameterTypes.length) {
                boolean match = true;
                int j = 0;
                while (j < parameters.length) {
                    ParameterDescriptor parameter = parameters[j];
                    Class<?> type = parameterTypes[j];
                    if (!type.getName().equals(parameter.getType())) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    return candidate;
                }
            }
            ++i;
        }
        throw new MetaClassException("No MethodDescriptor matching " + method);
    }

    public static MethodDescriptor getConstructor(Constructor constructor) throws MetaClassException {
        String name = constructor.getName();
        int index = name.lastIndexOf(".");
        if (-1 != index) {
            name = name.substring(index + 1);
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        MethodDescriptor[] methods = Attributes.getClassInfo(constructor.getDeclaringClass()).getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodDescriptor candidate = methods[i];
            ParameterDescriptor[] parameters = candidate.getParameters();
            if (candidate.getName().equals(name) && parameters.length == parameterTypes.length) {
                boolean match = true;
                int j = 0;
                while (j < parameters.length) {
                    String parameter = parameters[j].getType();
                    String type = parameterTypes[j].getName();
                    if (!type.equals(parameter)) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    return candidate;
                }
            }
            ++i;
        }
        throw new MetaClassException("No MethodDescriptor matching " + constructor);
    }

    private static ClassDescriptor getClassInfo(Class clazz) throws MetaClassException {
        return MetaClassIntrospector.getClassDescriptor(clazz);
    }
}

