/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.metaclass.introspector;

import java.io.InputStream;
import org.realityforge.metaclass.introspector.MetaClassAccessor;
import org.realityforge.metaclass.introspector.MetaClassException;
import org.realityforge.metaclass.io.MetaClassIO;
import org.realityforge.metaclass.io.MetaClassIOBinary;
import org.realityforge.metaclass.io.MetaClassIOXml;
import org.realityforge.metaclass.model.ClassDescriptor;

public class DefaultMetaClassAccessor
implements MetaClassAccessor {
    public static final String BINARY_EXT = "-meta.binary";
    public static final String XML_EXT = "-meta.xml";
    private static final MetaClassIO c_binaryIO;
    private static final MetaClassIO c_xmlIO;

    public ClassDescriptor getClassDescriptor(String classname, ClassLoader classLoader, MetaClassAccessor accessor) throws MetaClassException {
        boolean isXML = false;
        String baseName = classname.replace('.', '/');
        String resource = baseName + BINARY_EXT;
        InputStream inputStream = classLoader.getResourceAsStream(resource);
        if (null == inputStream) {
            resource = baseName + XML_EXT;
            inputStream = classLoader.getResourceAsStream(resource);
            isXML = true;
        }
        if (null == inputStream) {
            String message = "Missing Attributes for " + classname;
            throw new MetaClassException(message);
        }
        try {
            if (isXML) {
                return c_xmlIO.deserializeClass(inputStream);
            }
            return c_binaryIO.deserializeClass(inputStream);
        }
        catch (Exception e) {
            String message = "Unable to load Attributes for " + classname;
            throw new MetaClassException(message, e);
        }
    }

    static {
        BINARY_EXT = BINARY_EXT;
        XML_EXT = XML_EXT;
        c_binaryIO = new MetaClassIOBinary();
        c_xmlIO = new MetaClassIOXml();
    }
}

