/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.metaclass.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.realityforge.metaclass.io.MetaClassIO;
import org.realityforge.metaclass.model.Attribute;
import org.realityforge.metaclass.model.ClassDescriptor;
import org.realityforge.metaclass.model.FieldDescriptor;
import org.realityforge.metaclass.model.MethodDescriptor;
import org.realityforge.metaclass.model.ParameterDescriptor;

public class MetaClassIOBinary
implements MetaClassIO {
    static final int VERSION = 2;

    public ClassDescriptor deserializeClass(InputStream input) throws IOException {
        DataInputStream data = new DataInputStream(input);
        this.checkVersionHeader(data);
        String classname = data.readUTF();
        Attribute[] classAttributes = this.readAttributes(data);
        FieldDescriptor[] fields = this.readFields(data);
        MethodDescriptor[] methods = this.readMethods(data);
        return new ClassDescriptor(classname, classAttributes, classAttributes, fields, methods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeClass(OutputStream output, ClassDescriptor info) throws IOException {
        DataOutputStream data = new DataOutputStream(output);
        try {
            data.writeInt(2);
            data.writeUTF(info.getName());
            this.writeAttributes(data, info.getAttributes());
            this.writeFields(data, info.getFields());
            this.writeMethods(data, info.getMethods());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            data.flush();
            throw throwable;
        }
        data.flush();
    }

    void writeFields(DataOutputStream data, FieldDescriptor[] fields) throws IOException {
        data.writeInt(fields.length);
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor field = fields[i];
            this.writeField(data, field);
            ++i;
        }
    }

    private void writeField(DataOutputStream data, FieldDescriptor field) throws IOException {
        data.writeUTF(field.getName());
        data.writeUTF(field.getType());
        this.writeAttributes(data, field.getAttributes());
    }

    void writeMethods(DataOutputStream data, MethodDescriptor[] methods) throws IOException {
        data.writeInt(methods.length);
        int i = 0;
        while (i < methods.length) {
            MethodDescriptor method = methods[i];
            this.writeMethod(data, method);
            ++i;
        }
    }

    private void writeMethod(DataOutputStream data, MethodDescriptor method) throws IOException {
        data.writeUTF(method.getName());
        data.writeUTF(method.getReturnType());
        this.writeParameters(data, method.getParameters());
        this.writeAttributes(data, method.getAttributes());
    }

    MethodDescriptor[] readMethods(DataInputStream data) throws IOException {
        int methodCount = data.readInt();
        ArrayList<MethodDescriptor> methodSet = new ArrayList<MethodDescriptor>();
        int i = 0;
        while (i < methodCount) {
            methodSet.add(this.readMethod(data));
            ++i;
        }
        return methodSet.toArray(new MethodDescriptor[methodSet.size()]);
    }

    private MethodDescriptor readMethod(DataInputStream data) throws IOException {
        String name = data.readUTF();
        String type = data.readUTF();
        ParameterDescriptor[] parameters = this.readParameters(data);
        Attribute[] attributes = this.readAttributes(data);
        return new MethodDescriptor(name, type, parameters, attributes, attributes);
    }

    FieldDescriptor[] readFields(DataInputStream data) throws IOException {
        int fieldCount = data.readInt();
        ArrayList<FieldDescriptor> fieldSet = new ArrayList<FieldDescriptor>();
        int i = 0;
        while (i < fieldCount) {
            fieldSet.add(this.readField(data));
            ++i;
        }
        return fieldSet.toArray(new FieldDescriptor[fieldSet.size()]);
    }

    private FieldDescriptor readField(DataInputStream data) throws IOException {
        String name = data.readUTF();
        String type = data.readUTF();
        Attribute[] attributes = this.readAttributes(data);
        return new FieldDescriptor(name, type, attributes, attributes);
    }

    ParameterDescriptor[] readParameters(DataInputStream data) throws IOException {
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        int count = data.readInt();
        int i = 0;
        while (i < count) {
            parameters.add(this.readParameter(data));
            ++i;
        }
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[parameters.size()];
        return parameters.toArray(parameterDescriptorArray);
    }

    private ParameterDescriptor readParameter(DataInputStream data) throws IOException {
        String name = data.readUTF();
        String type = data.readUTF();
        return new ParameterDescriptor(name, type);
    }

    void writeParameters(DataOutputStream data, ParameterDescriptor[] parameters) throws IOException {
        data.writeInt(parameters.length);
        int i = 0;
        while (i < parameters.length) {
            ParameterDescriptor parameter = parameters[i];
            this.writeParameter(data, parameter);
            ++i;
        }
    }

    private void writeParameter(DataOutputStream data, ParameterDescriptor parameter) throws IOException {
        data.writeUTF(parameter.getName());
        data.writeUTF(parameter.getType());
    }

    Attribute[] readAttributes(DataInputStream data) throws IOException {
        int count = data.readInt();
        ArrayList<Attribute> attributeSet = new ArrayList<Attribute>();
        int i = 0;
        while (i < count) {
            boolean valuePresent;
            String name = data.readUTF();
            String value = data.readUTF();
            Properties properties = this.readAttributeParameters(data);
            Attribute attribute = null;
            boolean bl = valuePresent = null != value && value.length() > 0;
            if (valuePresent && ((Hashtable)properties).size() > 0) {
                String message = "Cannot read attributes containing both text and parameters.";
                throw new IOException("Cannot read attributes containing both text and parameters.");
            }
            attribute = valuePresent ? new Attribute(name, value) : new Attribute(name, properties);
            attributeSet.add(attribute);
            ++i;
        }
        return attributeSet.toArray(new Attribute[attributeSet.size()]);
    }

    Properties readAttributeParameters(DataInputStream data) throws IOException {
        Properties parameters = new Properties();
        int count = data.readInt();
        int i = 0;
        while (i < count) {
            String name = data.readUTF();
            String value = data.readUTF();
            parameters.setProperty(name, value);
            ++i;
        }
        return parameters;
    }

    void writeAttributes(DataOutputStream data, Attribute[] attributes) throws IOException {
        data.writeInt(attributes.length);
        int i = 0;
        while (i < attributes.length) {
            Attribute attribute = attributes[i];
            data.writeUTF(attribute.getName());
            String value = attribute.getValue();
            if (null != value) {
                data.writeUTF(value);
                this.writeAttributeParameters(data, null);
            } else {
                data.writeUTF("");
                this.writeAttributeParameters(data, attribute);
            }
            ++i;
        }
    }

    void writeAttributeParameters(DataOutputStream data, Attribute attribute) throws IOException {
        if (null == attribute) {
            data.writeInt(0);
        } else {
            String[] names = attribute.getParameterNames();
            data.writeInt(names.length);
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                String value = attribute.getParameter(name);
                data.writeUTF(name);
                data.writeUTF(value);
                ++i;
            }
        }
    }

    private void checkVersionHeader(DataInputStream data) throws IOException {
        int version = data.readInt();
        if (2 != version) {
            String message = "Version mismatch. Expected: 2 Actual: " + version;
            throw new IOException(message);
        }
    }

    static {
        VERSION = 2;
    }
}

