/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.metaclass.io;

import org.realityforge.metaclass.model.Attribute;
import org.realityforge.metaclass.model.ClassDescriptor;
import org.realityforge.metaclass.model.FieldDescriptor;
import org.realityforge.metaclass.model.MethodDescriptor;
import org.realityforge.metaclass.model.ParameterDescriptor;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXMetaClassSerializer {
    static final String CDATA_TYPE = "CDATA";
    static final String EMPTY_NAMESPACE = "";

    public void serialize(ContentHandler handler, ClassDescriptor descriptor) throws SAXException {
        handler.startDocument();
        this.serializeClass(handler, descriptor);
        handler.endDocument();
    }

    void serializeClass(ContentHandler handler, ClassDescriptor descriptor) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.add(atts, "type", descriptor.getName());
        this.add(atts, "version", "1.0");
        this.start(handler, "class", atts);
        this.serializeFields(handler, descriptor.getFields());
        this.serializeMethods(handler, descriptor.getMethods());
        this.serializeAttributes(handler, descriptor.getAttributes());
        this.end(handler, "class");
    }

    void serializeFields(ContentHandler handler, FieldDescriptor[] descriptors) throws SAXException {
        if (0 == descriptors.length) {
            return;
        }
        this.start(handler, "fields");
        int i = 0;
        while (i < descriptors.length) {
            this.serializeField(handler, descriptors[i]);
            ++i;
        }
        this.end(handler, "fields");
    }

    void serializeField(ContentHandler handler, FieldDescriptor descriptor) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.add(atts, "name", descriptor.getName());
        this.add(atts, "type", descriptor.getType());
        this.start(handler, "field", atts);
        this.serializeAttributes(handler, descriptor.getAttributes());
        this.end(handler, "field");
    }

    void serializeMethods(ContentHandler handler, MethodDescriptor[] descriptors) throws SAXException {
        if (0 == descriptors.length) {
            return;
        }
        this.start(handler, "methods");
        int i = 0;
        while (i < descriptors.length) {
            this.serializeMethod(handler, descriptors[i]);
            ++i;
        }
        this.end(handler, "methods");
    }

    void serializeMethod(ContentHandler handler, MethodDescriptor descriptor) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.add(atts, "name", descriptor.getName());
        this.add(atts, "type", descriptor.getReturnType());
        this.start(handler, "method", atts);
        this.serializeParameters(handler, descriptor.getParameters());
        this.serializeAttributes(handler, descriptor.getAttributes());
        this.end(handler, "method");
    }

    void serializeParameters(ContentHandler handler, ParameterDescriptor[] parameters) throws SAXException {
        if (0 == parameters.length) {
            return;
        }
        this.start(handler, "parameters");
        int i = 0;
        while (i < parameters.length) {
            this.serializeParameter(handler, parameters[i]);
            ++i;
        }
        this.end(handler, "parameters");
    }

    void serializeParameter(ContentHandler handler, ParameterDescriptor parameter) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.add(atts, "name", parameter.getName());
        this.add(atts, "type", parameter.getType());
        this.start(handler, "parameter", atts);
        this.end(handler, "parameter");
    }

    void serializeAttributes(ContentHandler handler, Attribute[] attributes) throws SAXException {
        if (0 == attributes.length) {
            return;
        }
        this.start(handler, "attributes");
        int i = 0;
        while (i < attributes.length) {
            this.serializeAttribute(handler, attributes[i]);
            ++i;
        }
        this.end(handler, "attributes");
    }

    void serializeAttribute(ContentHandler handler, Attribute attribute) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.add(atts, "name", attribute.getName());
        this.start(handler, "attribute", atts);
        this.text(handler, attribute.getValue());
        this.serializeAttributeParams(handler, attribute);
        this.end(handler, "attribute");
    }

    void serializeAttributeParams(ContentHandler handler, Attribute attribute) throws SAXException {
        String[] names = attribute.getParameterNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = attribute.getParameter(name);
            this.serializeAttributeParam(handler, name, value);
            ++i;
        }
    }

    void serializeAttributeParam(ContentHandler handler, String name, String value) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.add(atts, "name", name);
        this.add(atts, "value", value);
        this.start(handler, "param", atts);
        this.end(handler, "param");
    }

    void add(AttributesImpl atts, String name, String value) {
        atts.addAttribute(EMPTY_NAMESPACE, name, name, CDATA_TYPE, value);
    }

    void start(ContentHandler handler, String name) throws SAXException {
        this.start(handler, name, new AttributesImpl());
    }

    void start(ContentHandler handler, String name, AttributesImpl atts) throws SAXException {
        handler.startElement(EMPTY_NAMESPACE, name, name, atts);
    }

    void text(ContentHandler handler, String text) throws SAXException {
        if (null != text) {
            char[] ch = text.toCharArray();
            handler.characters(ch, 0, ch.length);
        }
    }

    void end(ContentHandler handler, String name) throws SAXException {
        handler.endElement(EMPTY_NAMESPACE, name, name);
    }

    static {
        CDATA_TYPE = CDATA_TYPE;
        EMPTY_NAMESPACE = EMPTY_NAMESPACE;
    }
}

