/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.metaclass.tools.qdox;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.Properties;
import org.realityforge.metaclass.model.Attribute;
import org.realityforge.metaclass.model.ClassDescriptor;
import org.realityforge.metaclass.model.FieldDescriptor;
import org.realityforge.metaclass.model.MethodDescriptor;
import org.realityforge.metaclass.model.ParameterDescriptor;
import org.realityforge.metaclass.tools.qdox.DefaultQDoxAttributeInterceptor;
import org.realityforge.metaclass.tools.qdox.MulticastInterceptor;
import org.realityforge.metaclass.tools.qdox.QDoxAttributeInterceptor;

public class QDoxDescriptorParser {
    private static final int PARSE_KEY_START = 0;
    private static final int PARSE_KEY = 1;
    private static final int PARSE_VALUE_START = 2;
    private static final int PARSE_VALUE = 3;
    private static final int PARSE_END = 4;

    public ClassDescriptor buildClassDescriptor(JavaClass javaClass) {
        return this.buildClassDescriptor(javaClass, new DefaultQDoxAttributeInterceptor());
    }

    public ClassDescriptor buildClassDescriptor(JavaClass javaClass, QDoxAttributeInterceptor[] interceptors) {
        return this.buildClassDescriptor(javaClass, new MulticastInterceptor(interceptors));
    }

    public ClassDescriptor buildClassDescriptor(JavaClass javaClass, QDoxAttributeInterceptor interceptor) {
        String classname = javaClass.getFullyQualifiedName();
        Attribute[] originalAttributes = this.buildAttributes(javaClass, interceptor);
        Attribute[] attributes = interceptor.processClassAttributes(javaClass, originalAttributes);
        FieldDescriptor[] fields = this.buildFields(javaClass.getFields(), interceptor);
        MethodDescriptor[] methods = this.buildMethods(javaClass.getMethods(), interceptor);
        return new ClassDescriptor(classname, attributes, attributes, fields, methods);
    }

    MethodDescriptor[] buildMethods(JavaMethod[] methods, QDoxAttributeInterceptor interceptor) {
        MethodDescriptor[] methodDescriptors = new MethodDescriptor[methods.length];
        int i = 0;
        while (i < methods.length) {
            methodDescriptors[i] = this.buildMethod(methods[i], interceptor);
            ++i;
        }
        return methodDescriptors;
    }

    MethodDescriptor buildMethod(JavaMethod method, QDoxAttributeInterceptor interceptor) {
        String name = method.getName();
        Type returns = method.getReturns();
        String type = null != returns ? returns.getValue() : "";
        Attribute[] originalAttributes = this.buildAttributes(method, interceptor);
        Attribute[] attributes = interceptor.processMethodAttributes(method, originalAttributes);
        ParameterDescriptor[] parameters = this.buildParameters(method.getParameters());
        return new MethodDescriptor(name, type, parameters, attributes, attributes);
    }

    ParameterDescriptor[] buildParameters(JavaParameter[] parameters) {
        ParameterDescriptor[] descriptors = new ParameterDescriptor[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            descriptors[i] = this.buildParameter(parameters[i]);
            ++i;
        }
        return descriptors;
    }

    ParameterDescriptor buildParameter(JavaParameter parameter) {
        String name = parameter.getName();
        String value = parameter.getType().getValue();
        return new ParameterDescriptor(name, value);
    }

    FieldDescriptor[] buildFields(JavaField[] fields, QDoxAttributeInterceptor interceptor) {
        FieldDescriptor[] fieldDescriptors = new FieldDescriptor[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldDescriptors[i] = this.buildField(fields[i], interceptor);
            ++i;
        }
        return fieldDescriptors;
    }

    FieldDescriptor buildField(JavaField field, QDoxAttributeInterceptor interceptor) {
        String name = field.getName();
        String type = field.getType().getValue();
        Attribute[] originalAttributes = this.buildAttributes(field, interceptor);
        Attribute[] attributes = interceptor.processFieldAttributes(field, originalAttributes);
        return new FieldDescriptor(name, type, attributes, attributes);
    }

    private Attribute[] buildAttributes(JavaClass javaClass, QDoxAttributeInterceptor interceptor) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        DocletTag[] tags = javaClass.getTags();
        int i = 0;
        while (i < tags.length) {
            Attribute originalAttribute = this.buildAttribute(tags[i]);
            Attribute attribute = interceptor.processClassAttribute(javaClass, originalAttribute);
            if (null != attribute) {
                attributes.add(attribute);
            }
            ++i;
        }
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    private Attribute[] buildAttributes(JavaMethod method, QDoxAttributeInterceptor interceptor) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        DocletTag[] tags = method.getTags();
        int i = 0;
        while (i < tags.length) {
            Attribute originalAttribute = this.buildAttribute(tags[i]);
            Attribute attribute = interceptor.processMethodAttribute(method, originalAttribute);
            if (null != attribute) {
                attributes.add(attribute);
            }
            ++i;
        }
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    private Attribute[] buildAttributes(JavaField field, QDoxAttributeInterceptor interceptor) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        DocletTag[] tags = field.getTags();
        int i = 0;
        while (i < tags.length) {
            Attribute originalAttribute = this.buildAttribute(tags[i]);
            Attribute attribute = interceptor.processFieldAttribute(field, originalAttribute);
            if (null != attribute) {
                attributes.add(attribute);
            }
            ++i;
        }
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    Attribute buildAttribute(DocletTag tag) {
        String name = tag.getName();
        String value = tag.getValue();
        if (null == value || "".equals(value.trim())) {
            return new Attribute(name);
        }
        Properties parameters = this.parseValueIntoParameters(value);
        if (null == parameters) {
            return new Attribute(name, value);
        }
        return new Attribute(name, parameters);
    }

    Properties parseValueIntoParameters(String input) {
        Properties parameters = new Properties();
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        int state = 0;
        int length = input.length();
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isJavaIdentifierStart(ch)) {
                        key.append(ch);
                        state = 1;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if ('=' == ch) {
                        state = 2;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(ch)) {
                        key.append(ch);
                        break;
                    }
                    return null;
                }
                case 2: {
                    if ('\"' != ch) {
                        return null;
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    if ('\"' == ch) {
                        state = 4;
                        parameters.setProperty(key.toString(), value.toString());
                        key.setLength(0);
                        value.setLength(0);
                        break;
                    }
                    value.append(ch);
                    break;
                }
                default: {
                    if (Character.isWhitespace(ch)) {
                        state = 0;
                        break;
                    }
                    return null;
                }
            }
            ++i;
        }
        if (0 != state && 4 != state) {
            return null;
        }
        return parameters;
    }

    static {
        PARSE_KEY_START = 0;
        PARSE_KEY = 1;
        PARSE_VALUE_START = 2;
        PARSE_VALUE = 3;
        PARSE_END = 4;
    }
}

