/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.metaclass.tools.tasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.realityforge.metaclass.tools.tasks.PluginSet;

abstract class AddToPluginSetTask
extends Task {
    private Class m_type;
    private String m_id;
    private String m_refid;

    AddToPluginSetTask(Class type) {
        this.m_type = type;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setRefid(String refid) {
        this.m_refid = refid;
    }

    public void execute() throws BuildException {
        this.validate();
        Object idObject = this.getProject().getReference(this.m_id);
        Object refidObject = this.getProject().getReference(this.m_refid);
        if (!this.m_type.isInstance(idObject)) {
            String message = "Object referenced by id is not a " + this.m_type.getName();
            throw new BuildException(message);
        }
        if (!this.m_type.isInstance(refidObject)) {
            String message = "Object referenced by refid is not a " + this.m_type.getName();
            throw new BuildException(message);
        }
        PluginSet base = (PluginSet)((Object)idObject);
        PluginSet other = (PluginSet)((Object)refidObject);
        base.addPluginSet(other);
    }

    void validate() {
        if (null == this.m_id) {
            throw new BuildException("id not specified");
        }
        if (null == this.m_refid) {
            throw new BuildException("refid not specified");
        }
    }
}

